;;;
;;;    LSPDATA.lsp- Express Tool data for lsp command
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
(defun c:lsp ( / lst n a b wc
                 acet-lsp-is-command acet-lsp-princ
                 core-symbol-list
                 com-symbol-list
                 reactor-symbol-list
             )
  (acet-error-init nil)
 
  (load "lspdata.lsp" "lspdata load failed")
 
  ;;;;local function for checking if _string_ argument provided
  ;;;;is bound to a command function (c:XXXX)
  (defun acet-lsp-is-command ( a / )
     (and (equal "C:" (substr (xstrcase a) 1 2))
          (acet-lsp-is-function (eval (read a)))
     );and
  );defun acet-lsp-is-command
 
  (defun acet-lsp-princ ( a / b c)
    (cond
     ((member a core-symbol-list) (setq b "Core"))
     ((member a com-symbol-list) (setq b "Com"))
     ((member a reactor-symbol-list) (setq b "Reactor"))
     (T (setq b ""))
    );cond close
    (if (setq c (type (eval (read a))))
        (setq c (vl-symbol-name c))
        (setq c "nil")
    );if
    (setq c (strcat "(" c ")"))
    (if (= "C:" (substr a 1 2))
        (setq a (substr a 3))
    );if
    (while (< (strlen a) 30)
     (setq a (strcat a " "))
    );while
    (while (< (strlen c) 30)
     (setq c (strcat c " "))
    );while
    (princ (strcat "\n" a c b))
  );defun acet-lsp-princ
 
  ;;;;;;get down to the buisness at hand...
 
  (initget "Commands Functions Variables Load ? _Commands Functions Variables Load ?")
  (setq a (getkword "\nEnter an option [?/Commands/Functions/Variables/Load]: "))
  (if (and a
           (/= "Load" a)
           (/= a "?")
      )
      (setq  wc (getstring (acet-str-format "\nEnter %1 to list <*>: " a))
            lst (atoms-family 1)
            lst (acad_strlsort lst)
      );setq
  );if
  (if (or (not wc)
          (= wc "")
      )
      (setq wc "*")
      (setq wc (xstrcase wc))
  );if
  (cond
    ((= a "Commands")
      (setq n 0);setq
      (repeat (length lst)
        (setq a (xstrcase (nth n lst)));setq
        (if (and (acet-lsp-is-command a)
                 (wcmatch (substr a 3) wc)
            );and
            (acet-lsp-princ a)
        );if
        (setq n (+ n 1))
      );repeat
    );cond 1
    ((= a "Functions")
      (setq n 0);setq
      (repeat (length lst)
        (setq a (xstrcase (nth n lst))
              b (eval (read a))
        );setq
        (if (and (wcmatch a wc)
                 b
                 (acet-lsp-is-function b)
            );and
            (acet-lsp-princ a)
        );if
        (setq n (+ n 1));setq
      );repeat
    );cond 2
   ((= a "Variables")
    (progn
     (setq n 0);setq
     (repeat (length lst)
      (setq a (xstrcase (nth n lst))
            b (eval (read a))
      );setq
      (if (and
           (not (acet-lsp-is-function b));not a function
           (not (acet-lsp-is-command a));not a command
           (wcmatch a wc)
          );and
          (progn
           (acet-lsp-princ a)
          );progn then
      );if
     (setq n (+ n 1))
     );repeat
    );progn then
   );cond 4
   ((= a "?")
    (help "acad_alr.chm" "")
   );cond 5
   ((= a "Load")
    (command "_.appload")
   );cond 6
 );cond close
 (acet-error-restore)
 (princ)
);defun c:lsp
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;Function for checking if argument provided is a function
(defun acet-lsp-is-function ( b / )
   (or (and (= 'LIST (type b))       ;;;;;;a list that looks like a function?
            (not (acet-list-is-dotted-pair b)) ;not a dotted pair
            (> (length b) 1)
            (or (= 'LIST (type (car b)))
                (not (car b))
            );or
       );and
       (= 'SUBR (type b))            ;;;;;;or a standard subroutine
       (= 'USUBR (type b))           ;;;;;;or a subroutine (w/IDE loaded)
       (= 'EXRXSUBR (type b))        ;;;;;;or an arx subroutine
   );or
);defun acet-lsp-is-function
 
 
 (setq core-symbol-list
       '(
         "*"
         "*ERROR*"
         "*VLISP-NEW-FULL-INIT*"
         "+"
         "-"
         "/"
         "/="
         "1+"
         "1-"
         ":CONSTANTS-PREFIX"
         ":FALSE"
         ":METHODS-PREFIX"
         ":PROG-ID"
         ":PROPERTIES-PREFIX"
         ":TLB-FILENAME"
         ":TRUE"
         ":VLAX-FALSE"
         ":VLAX-NULL"
         ":VLAX-TRUE"
         "<"
         "<="
         "="
         ">"
         ">="
         "ABS"
         "ACAD_COLORDLG"
         "ACAD_STRLSORT"
         "ACTION_TILE"
         "ADD_LIST"
         "ADS"
         "ALERT"
         "ALLOC"
         "AND"
         "ANGLE"
         "ANGTOF"
         "ANGTOS"
         "APPEND"
         "APPLY"
         "ARX"
         "ARXLOAD"
         "ARXUNLOAD"
         "ASCII"
         "ASSOC"
         "ATAN"
         "ATOF"
         "ATOI"
         "ATOM"
         "ATOMS-FAMILY"
         "BHATCH"
         "BHERRS"
         "BOOLE"
         "BOUNDP"
         "BPOLY"
         "C:PSDRAG"
         "C:PSFILL"
         "C:PSIN"
         "C:VLIDE"
         "CAAAAR"
         "CAAADR"
         "CAAAR"
         "CAADAR"
         "CAADDR"
         "CAADR"
         "CAAR"
         "CADAAR"
         "CADADR"
         "CADAR"
         "CADDAR"
         "CADDDR"
         "CADDR"
         "CADR"
         "CAR"
         "CDAAAR"
         "CDAADR"
         "CDAAR"
         "CDADAR"
         "CDADDR"
         "CDADR"
         "CDAR"
         "CDDAAR"
         "CDDADR"
         "CDDAR"
         "CDDDAR"
         "CDDDDR"
         "CDDDR"
         "CDDR"
         "CDR"
         "CHR"
         "CLIENT_DATA_TILE"
         "CLOSE"
         "COMMAND"
         "COND"
         "CONS"
         "COS"
         "CVUNIT"
         "DEFUN"
         "DEFUN-Q"
         "DEFUN-Q-LIST-REF"
         "DEFUN-Q-LIST-SET"
         "DICTADD"
         "DICTNEXT"
         "DICTREMOVE"
         "DICTRENAME"
         "DICTSEARCH"
         "DIMX_TILE"
         "DIMY_TILE"
         "DISTANCE"
         "DISTOF"
         "DONE_DIALOG"
         "END_IMAGE"
         "END_LIST"
         "ENTDEL"
         "ENTGET"
         "ENTLAST"
         "ENTMAKE"
         "ENTMAKEX"
         "ENTMOD"
         "ENTNEXT"
         "ENTSEL"
         "ENTUPD"
         "EQ"
         "EQUAL"
         "EVAL"
         "EXIT"
         "EXP"
         "EXPAND"
         "EXPT"
         "FILL_IMAGE"
         "FINDFILE"
         "FIX"
         "FLOAT"
         "FNSPLITL"
         "FOREACH"
         "FUNCTION"
         "GC"
         "GCD"
         "GETANGLE"
         "GETCFG"
         "GETCNAME"
         "GETCORNER"
         "GETDIST"
         "GETENV"
         "GETFILED"
         "GETINT"
         "GETKWORD"
         "GETORIENT"
         "GETPOINT"
         "GETREAL"
         "GETSTRING"
         "GETURL"
         "GETVAR"
         "GET_ATTR"
         "GET_TILE"
         "GRAPHSCR"
         "GRCLEAR"
         "GRDRAW"
         "GRREAD"
         "GRTEXT"
         "GRVECS"
         "HANDENT"
         "HELP"
         "IF"
         "INITDIA"
         "INITGET"
         "INTERS"
         "ISMNUGRPLOADED"
         "ITOA"
         "LAMBDA"
         "LAST"
         "LAYOUTLIST"
         "LENGTH"
         "LIST"
         "LISTP"
         "LOAD"
         "LOAD_DIALOG"
         "LOG"
         "LOGAND"
         "LOGIOR"
         "LSH"
         "MAPCAR"
         "MAX"
         "MEM"
         "MEMBER"
         "MENUCMD"
         "MENUGROUP"
         "MIN"
         "MINUSP"
         "MODE_TILE"
         "MTEDIT"
         "MTPROP"
         "NAMEDOBJDICT"
         "NENTSEL"
         "NENTSELP"
         "NEW_DIALOG"
         "NOT"
         "NTH"
         "NULL"
         "NUMBERP"
         "OPEN"
         "OR"
         "OSNAP"
         "PAUSE"
         "PI"
         "POLAR"
         "PRAGMA"
         "PRIN1"
         "PRINC"
         "PRINT"
         "PROGN"
         "PROMPT"
         "QUIT"
         "QUOTE"
         "READ"
         "READ-CHAR"
         "READ-LINE"
         "REDRAW"
         "REGAPP"
         "REM"
         "REPEAT"
         "REPORT"
         "REVERSE"
         "RTOS"
         "SET"
         "SETCFG"
         "SETENV"
         "SETFUNHELP"
         "SETQ"
         "SETURL"
         "SETVAR"
         "SETVIEW"
         "SET_TILE"
         "SIN"
         "SLIDE_IMAGE"
         "SNVALID"
         "SQRT"
         "SSADD"
         "SSDEL"
         "SSGET"
         "SSGETFIRST"
         "SSLENGTH"
         "SSMEMB"
         "SSNAME"
         "SSNAMEX"
         "SSSETFIRST"
         "STARTAPP"
         "START_DIALOG"
         "START_IMAGE"
         "START_LIST"
         "STRCASE"
         "STRCAT"
         "STRLEN"
         "SUBST"
         "SUBSTR"
         "T"
         "TABLET"
         "TBLNEXT"
         "TBLOBJNAME"
         "TBLSEARCH"
         "TERM_DIALOG"
         "TERPRI"
         "TEXTBOX"
         "TEXTPAGE"
         "TEXTSCR"
         "TRACE"
         "TRANS"
         "TYPE"
         "UNLOAD_DIALOG"
         "UNTRACE"
         "VECTOR_IMAGE"
         "VER"
         "VL-ACAD-DEFUN"
         "VL-ACAD-UNDEFUN"
         "VL-ARX-IMPORT"
         "VL-BB-REF"
         "VL-BB-SET"
         "VL-BT"
         "VL-BT-OFF"
         "VL-BT-ON"
         "VL-CMDF"
         "VL-CONSP"
         "VL-DIRECTORY-FILES"
         "VL-DOC-EXPORT"
         "VL-DOC-IMPORT"
         "VL-DOC-REF"
         "VL-DOC-SET"
         "VL-EVERY"
         "VL-EXIT-WITH-ERROR"
         "VL-EXIT-WITH-VALUE"
         "VL-FILE-COPY"
         "VL-FILE-DELETE"
         "VL-FILE-DIRECTORY-P"
         "VL-FILE-RENAME"
         "VL-FILE-SIZE"
         "VL-FILE-SYSTIME"
         "VL-FILENAME-BASE"
         "VL-FILENAME-DIRECTORY"
         "VL-FILENAME-EXTENSION"
         "VL-FILENAME-MKTEMP"
         "VL-GET-RESOURCE"
         "VL-INFP"
         "VL-INIT"
         "VL-LIST*"
         "VL-LIST->STRING"
         "VL-LIST-EXPORTED-FUNCTIONS"
         "VL-LIST-LENGTH"
         "VL-LIST-LOADED-VLX"
         "VL-LOAD-ALL"
         "VL-LOAD-COM"
         "VL-LOAD-REACTORS"
         "VL-MEMBER-IF"
         "VL-MEMBER-IF-NOT"
         "VL-MKDIR"
         "VL-NANP"
         "VL-POSITION"
         "VL-PRIN1-TO-STRING"
         "VL-PRINC-TO-STRING"
         "VL-PROPAGATE"
         "VL-REGISTRY-DELETE"
         "VL-REGISTRY-DESCENDENTS"
         "VL-REGISTRY-READ"
         "VL-REGISTRY-WRITE"
         "VL-REMOVE"
         "VL-REMOVE-IF"
         "VL-REMOVE-IF-NOT"
         "VL-SOME"
         "VL-SORT"
         "VL-SORT-I"
         "VL-STRING->LIST"
         "VL-STRING-ELT"
         "VL-STRING-LEFT-TRIM"
         "VL-STRING-MISMATCH"
         "VL-STRING-POSITION"
         "VL-STRING-RIGHT-TRIM"
         "VL-STRING-SEARCH"
         "VL-STRING-SUBST"
         "VL-STRING-TRANSLATE"
         "VL-STRING-TRIM"
         "VL-SYMBOL-NAME"
         "VL-SYMBOL-VALUE"
         "VL-SYMBOLP"
         "VL-UNLOAD-VLX"
         "VL-VBALOAD"
         "VL-VBARUN"
         "VLARTS-INIT"
         "VLAX-FOR"
         "VLISP-DCLRES-LIST"
         "VLISP-DCLRES-LOAD-DIALOG"
         "VLISP-EXPORT-SYMBOL"
         "VLISP-FASRES-LIST"
         "VLISP-FASRES-LOAD"
         "VLISP-IMPORT-EXSUBRS"
         "VLISP-IMPORT-SYMBOL"
         "VLISP-INIRES-LIST"
         "VLX-LOADED-P"
         "VMON"
         "VPORTS"
         "WCMATCH"
         "WHILE"
         "WRITE-CHAR"
         "WRITE-LINE"
         "XDROOM"
         "XDSIZE"
         "XSTRCASE"
         "ZEROP"
         "_VER"
         "_VL-FAST-MODE"
         "_VL-TIMES"
         "_VLISP-VERSION"
         "~"
        )
 )
 (setq com-symbol-list
       '(
         ":VLR-"
         ":VLR-ABORTATTACH"
         ":VLR-ABORTDEEPCLONE"
         ":VLR-ABORTDXFIN"
         ":VLR-ABORTDXFOUT"
         ":VLR-ABORTINSERT"
         ":VLR-ABORTRESTORE"
         ":VLR-ABORTWBLOCK"
         ":VLR-ACDB-REACTOR"
         ":VLR-BEGINATTACH"
         ":VLR-BEGINCLOSE"
         ":VLR-BEGINDEEPCLONE"
         ":VLR-BEGINDEEPCLONEXLATION"
         ":VLR-BEGINDOUBLECLICK"
         ":VLR-BEGINDWGOPEN"
         ":VLR-BEGINDXFIN"
         ":VLR-BEGINDXFOUT"
         ":VLR-BEGININSERT"
         ":VLR-BEGININSERTM"
         ":VLR-BEGINRESTORE"
         ":VLR-BEGINRIGHTCLICK"
         ":VLR-BEGINSAVE"
         ":VLR-BEGINWBLOCK"
         ":VLR-BEGINWBLOCKID"
         ":VLR-BEGINWBLOCKOBJECTS"
         ":VLR-BEGINWBLOCKPT"
         ":VLR-CANCELLED"
         ":VLR-COMANDEERED"
         ":VLR-COMMAND-REACTOR"
         ":VLR-COMMANDCANCELLED"
         ":VLR-COMMANDENDED"
         ":VLR-COMMANDFAILED"
         ":VLR-COMMANDWILLSTART"
         ":VLR-COPIED"
         ":VLR-DATABASECONSTRUCTED"
         ":VLR-DATABASETOBEDESTROYED"
         ":VLR-DEEPCLONE-REACTOR"
         ":VLR-DOCFRAMEMOVEDORRESIZED"
         ":VLR-DOCMANAGER-REACTOR"
         ":VLR-DOCUMENTBECAMECURRENT"
         ":VLR-DOCUMENTCREATED"
         ":VLR-DOCUMENTLOCKMODECHANGED"
         ":VLR-DOCUMENTLOCKMODECHANGEVETOED"
         ":VLR-DOCUMENTLOCKMODEWILLCHANGE"
         ":VLR-DOCUMENTTOBEACTIVATED"
         ":VLR-DOCUMENTTOBEDEACTIVATED"
         ":VLR-DOCUMENTTOBEDESTROYED"
         ":VLR-DWG-REACTOR"
         ":VLR-DWGFILEOPENED"
         ":VLR-DXF-REACTOR"
         ":VLR-DXFINCOMPLETE"
         ":VLR-DXFOUTCOMPLETE"
         ":VLR-EDITOR-REACTOR"
         ":VLR-ENDATTACH"
         ":VLR-ENDDEEPCLONE"
         ":VLR-ENDDWGOPEN"
         ":VLR-ENDINSERT"
         ":VLR-ENDRESTORE"
         ":VLR-ENDWBLOCK"
         ":VLR-ERASED"
         ":VLR-GOODBYE"
         ":VLR-INSERT-REACTOR"
         ":VLR-LAYOUTSWITCHED"
         ":VLR-LINKER-REACTOR"
         ":VLR-LISP-REACTOR"
         ":VLR-LISPCANCELLED"
         ":VLR-LISPENDED"
         ":VLR-LISPWILLSTART"
         ":VLR-MAINFRAMEMOVEDORRESIZED"
         ":VLR-MISCELLANEOUS-REACTOR"
         ":VLR-MODIFIED"
         ":VLR-MODIFIEDXDATA"
         ":VLR-MODIFYUNDONE"
         ":VLR-MOUSE-REACTOR"
         ":VLR-OBJECT-REACTOR"
         ":VLR-OBJECTAPPENDED"
         ":VLR-OBJECTCLOSED"
         ":VLR-OBJECTERASED"
         ":VLR-OBJECTMODIFIED"
         ":VLR-OBJECTOPENEDFORMODIFY"
         ":VLR-OBJECTREAPPENDED"
         ":VLR-OBJECTUNAPPENDED"
         ":VLR-OBJECTUNERASED"
         ":VLR-OPENEDFORMODIFY"
         ":VLR-OTHERATTACH"
         ":VLR-OTHERINSERT"
         ":VLR-OTHERWBLOCK"
         ":VLR-PICKFIRSTMODIFIED"
         ":VLR-REAPPENDED"
         ":VLR-REDIRECTED"
         ":VLR-RXAPPLOADED"
         ":VLR-RXAPPUNLOADED"
         ":VLR-SAVECOMPLETE"
         ":VLR-SUBOBJMODIFIED"
         ":VLR-SYSVAR-REACTOR"
         ":VLR-SYSVARCHANGED"
         ":VLR-SYSVARWILLCHANGE"
         ":VLR-TOOLBAR-REACTOR"
         ":VLR-TOOLBARBITMAPSIZECHANGED"
         ":VLR-TOOLBARBITMAPSIZEWILLCHANGE"
         ":VLR-UNAPPENDED"
         ":VLR-UNDO-REACTOR"
         ":VLR-UNDOSUBCOMMANDAUTO"
         ":VLR-UNDOSUBCOMMANDBACK"
         ":VLR-UNDOSUBCOMMANDBEGIN"
         ":VLR-UNDOSUBCOMMANDCONTROL"
         ":VLR-UNDOSUBCOMMANDEND"
         ":VLR-UNDOSUBCOMMANDMARK"
         ":VLR-UNDOSUBCOMMANDNUMBER"
         ":VLR-UNERASED"
         ":VLR-UNKNOWNCOMMAND"
         ":VLR-WBLOCK-REACTOR"
         ":VLR-WBLOCKNOTICE"
         ":VLR-WINDOW-REACTOR"
         ":VLR-XREF-REACTOR"
         ":VLR-XREFSUBCOMMANDATTACHITEM"
         ":VLR-XREFSUBCOMMANDBINDITEM"
         ":VLR-XREFSUBCOMMANDDETACHITEM"
         ":VLR-XREFSUBCOMMANDOVERLAYITEM"
         ":VLR-XREFSUBCOMMANDPATHITEM"
         ":VLR-XREFSUBCOMMANDRELOADITEM"
         ":VLR-XREFSUBCOMMANDUNLOADITEM"
         "AC0DEGREES"
         "AC100_1"
         "AC10_1"
         "AC180DEGREES"
         "AC1FT_1FT"
         "AC1IN_1FT"
         "AC1_1"
         "AC1_10"
         "AC1_100"
         "AC1_128IN_1FT"
         "AC1_16"
         "AC1_16IN_1FT"
         "AC1_2"
         "AC1_20"
         "AC1_2IN_1FT"
         "AC1_30"
         "AC1_32IN_1FT"
         "AC1_4"
         "AC1_40"
         "AC1_4IN_1FT"
         "AC1_50"
         "AC1_64IN_1FT"
         "AC1_8"
         "AC1_8IN_1FT"
         "AC270DEGREES"
         "AC2_1"
         "AC3DFACE"
         "AC3DPOLYLINE"
         "AC3DSOLID"
         "AC3IN_1FT"
         "AC3_16IN_1FT"
         "AC3_32IN_1FT"
         "AC3_4IN_1FT"
         "AC3_8IN_1FT"
         "AC4_1"
         "AC6IN_1FT"
         "AC8_1"
         "AC90DEGREES"
         "ACABOVE"
         "ACACTIVEVIEWPORT"
         "ACALIGNMENTALIGNED"
         "ACALIGNMENTBOTTOMCENTER"
         "ACALIGNMENTBOTTOMLEFT"
         "ACALIGNMENTBOTTOMRIGHT"
         "ACALIGNMENTCENTER"
         "ACALIGNMENTFIT"
         "ACALIGNMENTLEFT"
         "ACALIGNMENTMIDDLE"
         "ACALIGNMENTMIDDLECENTER"
         "ACALIGNMENTMIDDLELEFT"
         "ACALIGNMENTMIDDLERIGHT"
         "ACALIGNMENTRIGHT"
         "ACALIGNMENTTOPCENTER"
         "ACALIGNMENTTOPLEFT"
         "ACALIGNMENTTOPRIGHT"
         "ACALIGNPNTACQUISITIONAUTOMATIC"
         "ACALIGNPNTACQUISITIONSHIFTTOACQUIRE"
         "ACALLVIEWPORTS"
         "ACARC"
         "ACARCHITECTURAL"
         "ACARROWARCHTICK"
         "ACARROWBOXBLANK"
         "ACARROWBOXFILLED"
         "ACARROWCLOSED"
         "ACARROWCLOSEDBLANK"
         "ACARROWDATUMBLANK"
         "ACARROWDATUMFILLED"
         "ACARROWDEFAULT"
         "ACARROWDOT"
         "ACARROWDOTBLANK"
         "ACARROWDOTSMALL"
         "ACARROWINTEGRAL"
         "ACARROWNONE"
         "ACARROWOBLIQUE"
         "ACARROWOPEN"
         "ACARROWOPEN30"
         "ACARROWOPEN90"
         "ACARROWORIGIN"
         "ACARROWORIGIN2"
         "ACARROWSMALL"
         "ACARROWSONLY"
         "ACARROWUSERDEFINED"
         "ACATTACHMENTPOINTBOTTOMCENTER"
         "ACATTACHMENTPOINTBOTTOMLEFT"
         "ACATTACHMENTPOINTBOTTOMRIGHT"
         "ACATTACHMENTPOINTMIDDLECENTER"
         "ACATTACHMENTPOINTMIDDLELEFT"
         "ACATTACHMENTPOINTMIDDLERIGHT"
         "ACATTACHMENTPOINTTOPCENTER"
         "ACATTACHMENTPOINTTOPLEFT"
         "ACATTACHMENTPOINTTOPRIGHT"
         "ACATTRIBUTE"
         "ACATTRIBUTEMODECONSTANT"
         "ACATTRIBUTEMODEINVISIBLE"
         "ACATTRIBUTEMODEPRESET"
         "ACATTRIBUTEMODEVERIFY"
         "ACATTRIBUTEREFERENCE"
         "ACBASEMENUGROUP"
         "ACBESTFIT"
         "ACBEZIERSURFACEMESH"
         "ACBLOCKREFERENCE"
         "ACBLUE"
         "ACBOTTOMTOTOP"
         "ACBYBLOCK"
         "ACBYLAYER"
         "ACBYSTYLE"
         "ACCENTERLINE"
         "ACCENTERMARK"
         "ACCENTERNONE"
         "ACCIRCLE"
         "ACCUBICSPLINE3DPOLY"
         "ACCUBICSPLINEPOLY"
         "ACCUBICSURFACEMESH"
         "ACCYAN"
         "ACDECIMAL"
         "ACDEFAULTUNITS"
         "ACDEGREEMINUTESECONDS"
         "ACDEGREES"
         "ACDEMANDLOADCMDINVOKE"
         "ACDEMANDLOADDISABLED"
         "ACDEMANDLOADENABLED"
         "ACDEMANDLOADENABLEDWITHCOPY"
         "ACDEMANDLOADONOBJECTDETECT"
         "ACDEMANLOADDISABLE"
         "ACDIAGONAL"
         "ACDIM3POINTANGULAR"
         "ACDIMALIGNED"
         "ACDIMANGULAR"
         "ACDIMARCHITECTURAL"
         "ACDIMARCHITECTURALSTACKED"
         "ACDIMDECIMAL"
         "ACDIMDIAMETRIC"
         "ACDIMENGINEERING"
         "ACDIMFRACTIONAL"
         "ACDIMFRACTIONALSTACKED"
         "ACDIMLARCHITECTURAL"
         "ACDIMLDECIMAL"
         "ACDIMLENGINEERING"
         "ACDIMLFRACTIONAL"
         "ACDIMLINEWITHTEXT"
         "ACDIMLSCIENTIFIC"
         "ACDIMLWINDOWSDESKTOP"
         "ACDIMORDINATE"
         "ACDIMPRECISIONEIGHT"
         "ACDIMPRECISIONFIVE"
         "ACDIMPRECISIONFOUR"
         "ACDIMPRECISIONONE"
         "ACDIMPRECISIONSEVEN"
         "ACDIMPRECISIONSIX"
         "ACDIMPRECISIONTHREE"
         "ACDIMPRECISIONTWO"
         "ACDIMPRECISIONZERO"
         "ACDIMRADIAL"
         "ACDIMROTATED"
         "ACDIMSCIENTIFIC"
         "ACDIMWINDOWSDESKTOP"
         "ACDISPLAY"
         "ACDISPLAYDCS"
         "ACDRAGDISPLAYAUTOMATICALLY"
         "ACDRAGDISPLAYONREQUEST"
         "ACDRAGDONOTDISPLAY"
         "ACELLIPSE"
         "ACENGINEERING"
         "ACENGLISH"
         "ACEXTENDBOTH"
         "ACEXTENDNONE"
         "ACEXTENDOTHERENTITY"
         "ACEXTENDTHISENTITY"
         "ACEXTENTS"
         "ACEXTERNALREFERENCE"
         "ACFALSE"
         "ACFIRSTEXTENSIONLINE"
         "ACFITCURVEPOLY"
         "ACFONTBOLD"
         "ACFONTBOLDITALIC"
         "ACFONTITALIC"
         "ACFONTREGULAR"
         "ACFRACTIONAL"
         "ACFULLPREVIEW"
         "ACGRADS"
         "ACGREEN"
         "ACGROUP"
         "ACHATCH"
         "ACHATCHLOOPTYPEDEFAULT"
         "ACHATCHLOOPTYPEDERIVED"
         "ACHATCHLOOPTYPEEXTERNAL"
         "ACHATCHLOOPTYPEPOLYLINE"
         "ACHATCHLOOPTYPETEXTBOX"
         "ACHATCHPATTERNTYPECUSTOMDEFINED"
         "ACHATCHPATTERNTYPEPREDEFINED"
         "ACHATCHPATTERNTYPEUSERDEFINED"
         "ACHATCHSTYLEIGNORE"
         "ACHATCHSTYLENORMAL"
         "ACHATCHSTYLEOUTER"
         "ACHORIZONTAL"
         "ACHORIZONTALALIGNMENTALIGNED"
         "ACHORIZONTALALIGNMENTCENTER"
         "ACHORIZONTALALIGNMENTFIT"
         "ACHORIZONTALALIGNMENTLEFT"
         "ACHORIZONTALALIGNMENTMIDDLE"
         "ACHORIZONTALALIGNMENTRIGHT"
         "ACHORZCENTERED"
         "ACINCHES"
         "ACINSERTUNITSANGSTROMS"
         "ACINSERTUNITSASTRONOMICALUNITS"
         "ACINSERTUNITSAUTOASSIGN"
         "ACINSERTUNITSCENTIMETERS"
         "ACINSERTUNITSDECAMETERS"
         "ACINSERTUNITSDECIMETERS"
         "ACINSERTUNITSFEET"
         "ACINSERTUNITSGIGAMETERS"
         "ACINSERTUNITSHECTOMETERS"
         "ACINSERTUNITSINCHES"
         "ACINSERTUNITSKILOMETERS"
         "ACINSERTUNITSLIGHTYEARS"
         "ACINSERTUNITSMETERS"
         "ACINSERTUNITSMICROINCHES"
         "ACINSERTUNITSMICRONS"
         "ACINSERTUNITSMILES"
         "ACINSERTUNITSMILLIMETERS"
         "ACINSERTUNITSMILS"
         "ACINSERTUNITSNANOMETERS"
         "ACINSERTUNITSPARSECS"
         "ACINSERTUNITSPROMPT"
         "ACINSERTUNITSUNITLESS"
         "ACINSERTUNITSYARDS"
         "ACINTERSECTION"
         "ACJIS"
         "ACKEYBOARDENTRY"
         "ACKEYBOARDENTRYEXCEPTSCRIPTS"
         "ACKEYBOARDRUNNINGOBJSNAP"
         "ACLAYOUT"
         "ACLEADER"
         "ACLEFTTORIGHT"
         "ACLIMITS"
         "ACLINE"
         "ACLINENOARROW"
         "ACLINESPACINGSTYLEATLEAST"
         "ACLINESPACINGSTYLEEXACTLY"
         "ACLINEWITHARROW"
         "ACLNWT000"
         "ACLNWT005"
         "ACLNWT009"
         "ACLNWT013"
         "ACLNWT015"
         "ACLNWT018"
         "ACLNWT020"
         "ACLNWT025"
         "ACLNWT030"
         "ACLNWT035"
         "ACLNWT040"
         "ACLNWT050"
         "ACLNWT053"
         "ACLNWT060"
         "ACLNWT070"
         "ACLNWT080"
         "ACLNWT090"
         "ACLNWT100"
         "ACLNWT106"
         "ACLNWT120"
         "ACLNWT140"
         "ACLNWT158"
         "ACLNWT200"
         "ACLNWT211"
         "ACLNWTBYBLOCK"
         "ACLNWTBYLAYER"
         "ACLNWTBYLWDEFAULT"
         "ACMAGENTA"
         "ACMAX"
         "ACMENUFILECOMPILED"
         "ACMENUFILESOURCE"
         "ACMENUITEM"
         "ACMENUSEPARATOR"
         "ACMENUSUBMENU"
         "ACMETRIC"
         "ACMILLIMETERS"
         "ACMIN"
         "ACMINSERTBLOCK"
         "ACMLINE"
         "ACMODELSPACE"
         "ACMOVETEXTADDLEADER"
         "ACMOVETEXTNOLEADER"
         "ACMTEXT"
         "ACNATIVE"
         "ACNORM"
         "ACNOTSTACKED"
         "ACOFF"
         "ACON"
         "ACOQGRAPHICS"
         "ACOQHIGHPHOTO"
         "ACOQLINEART"
         "ACOQPHOTO"
         "ACOQTEXT"
         "ACOUTSIDE"
         "ACOVERFIRSTEXTENSION"
         "ACOVERSECONDEXTENSION"
         "ACPALETTEBYDRAWING"
         "ACPALETTEBYSESSION"
         "ACPAPERSPACE"
         "ACPAPERSPACEDCS"
         "ACPARTIALMENUGROUP"
         "ACPARTIALPREVIEW"
         "ACPENWIDTH013"
         "ACPENWIDTH018"
         "ACPENWIDTH025"
         "ACPENWIDTH035"
         "ACPENWIDTH050"
         "ACPENWIDTH070"
         "ACPENWIDTH100"
         "ACPENWIDTH140"
         "ACPENWIDTH200"
         "ACPENWIDTHUNK"
         "ACPIXELS"
         "ACPLOTORIENTATIONLANDSCAPE"
         "ACPLOTORIENTATIONPORTRAIT"
         "ACPOINT"
         "ACPOLICYLEGACYDEFAULT"
         "ACPOLICYLEGACYLEGACY"
         "ACPOLICYLEGACYQUERY"
         "ACPOLICYNEWDEFAULT"
         "ACPOLICYNEWLEGACY"
         "ACPOLYFACEMESH"
         "ACPOLYLINE"
         "ACPOLYLINELIGHT"
         "ACPOLYMESH"
         "ACPREFERENCECLASSIC"
         "ACPREFERENCECUSTOM"
         "ACPRINTERALERTONCE"
         "ACPRINTERALWAYSALERT"
         "ACPRINTERNEVERALERT"
         "ACPRINTERNEVERALERTLOGONCE"
         "ACPROXYBOUNDINGBOX"
         "ACPROXYNOTSHOW"
         "ACPROXYSHOW"
         "ACPVIEWPORT"
         "ACQUADSPLINE3DPOLY"
         "ACQUADSPLINEPOLY"
         "ACQUADSURFACEMESH"
         "ACR12_DXF"
         "ACR13_DWG"
         "ACR13_DXF"
         "ACR14_DWG"
         "ACR14_DXF"
         "ACR15_DWG"
         "ACR15_DXF"
         "ACR15_TEMPLATE"
         "ACRADIANS"
         "ACRASTER"
         "ACRAY"
         "ACRED"
         "ACREGION"
         "ACRIGHTTOLEFT"
         "ACSCALETOFIT"
         "ACSCIENTIFIC"
         "ACSECONDEXTENSIONLINE"
         "ACSELECTIONSETALL"
         "ACSELECTIONSETCROSSING"
         "ACSELECTIONSETCROSSINGPOLYGON"
         "ACSELECTIONSETFENCE"
         "ACSELECTIONSETLAST"
         "ACSELECTIONSETPREVIOUS"
         "ACSELECTIONSETWINDOW"
         "ACSELECTIONSETWINDOWPOLYGON"
         "ACSHAPE"
         "ACSIMPLE3DPOLY"
         "ACSIMPLEMESH"
         "ACSIMPLEPOLY"
         "ACSOLID"
         "ACSPLINE"
         "ACSPLINENOARROW"
         "ACSPLINEWITHARROW"
         "ACSUBTRACTION"
         "ACTEXT"
         "ACTEXTANDARROWS"
         "ACTEXTFLAGBACKWARD"
         "ACTEXTFLAGUPSIDEDOWN"
         "ACTEXTONLY"
         "ACTOLBASIC"
         "ACTOLBOTTOM"
         "ACTOLDEVIATION"
         "ACTOLERANCE"
         "ACTOLLIMITS"
         "ACTOLMIDDLE"
         "ACTOLNONE"
         "ACTOLSYMMETRICAL"
         "ACTOLTOP"
         "ACTOOLBARBUTTON"
         "ACTOOLBARCONTROL"
         "ACTOOLBARDOCKBOTTOM"
         "ACTOOLBARDOCKLEFT"
         "ACTOOLBARDOCKRIGHT"
         "ACTOOLBARDOCKTOP"
         "ACTOOLBARFLOATING"
         "ACTOOLBARFLYOUT"
         "ACTOOLBARSEPARATOR"
         "ACTOPTOBOTTOM"
         "ACTRACE"
         "ACTRUE"
         "ACUCS"
         "ACUNION"
         "ACUNKNOWN"
         "ACVERTCENTERED"
         "ACVERTICALALIGNMENTBASELINE"
         "ACVERTICALALIGNMENTBOTTOM"
         "ACVERTICALALIGNMENTMIDDLE"
         "ACVERTICALALIGNMENTTOP"
         "ACVIEW"
         "ACVIEWPORT2HORIZONTAL"
         "ACVIEWPORT2VERTICAL"
         "ACVIEWPORT3ABOVE"
         "ACVIEWPORT3BELOW"
         "ACVIEWPORT3HORIZONTAL"
         "ACVIEWPORT3LEFT"
         "ACVIEWPORT3RIGHT"
         "ACVIEWPORT3VERTICAL"
         "ACVIEWPORT4"
         "ACVP100_1"
         "ACVP10_1"
         "ACVP1FT_1FT"
         "ACVP1IN_1FT"
         "ACVP1_1"
         "ACVP1_10"
         "ACVP1_100"
         "ACVP1_128IN_1FT"
         "ACVP1_16"
         "ACVP1_16IN_1FT"
         "ACVP1_2"
         "ACVP1_20"
         "ACVP1_2IN_1FT"
         "ACVP1_30"
         "ACVP1_32IN_1FT"
         "ACVP1_4"
         "ACVP1_40"
         "ACVP1_4IN_1FT"
         "ACVP1_50"
         "ACVP1_64IN_1FT"
         "ACVP1_8"
         "ACVP1_8IN_1FT"
         "ACVP2_1"
         "ACVP3IN_1FT"
         "ACVP3_16IN_1FT"
         "ACVP3_32IN_1FT"
         "ACVP3_4IN_1FT"
         "ACVP3_8IN_1FT"
         "ACVP4_1"
         "ACVP6IN_1FT"
         "ACVP8_1"
         "ACVPCUSTOMSCALE"
         "ACVPSCALETOFIT"
         "ACWHITE"
         "ACWINDOW"
         "ACWORLD"
         "ACXLINE"
         "ACYELLOW"
         "ACZOOMSCALEDABSOLUTE"
         "ACZOOMSCALEDRELATIVE"
         "ACZOOMSCALEDRELATIVEPSPACE"
         "SAFEARRAY"
         "SAFEARRAY-GET-DIM"
         "SAFEARRAY-GET-ELEMENT"
         "SAFEARRAY-GET-L-BOUND"
         "SAFEARRAY-GET-U-BOUND"
         "SAFEARRAY-PUT-ELEMENT"
         "SAFEARRAY-TYPE"
         "SAFEARRAY-VALUE"
         "VARIANT"
         "VARIANT-TYPE"
         "VARIANT-VALUE"
         "VLA-ACTIVATE"
         "VLA-ADD"
         "VLA-ADD3DFACE"
         "VLA-ADD3DMESH"
         "VLA-ADD3DPOLY"
         "VLA-ADDARC"
         "VLA-ADDATTRIBUTE"
         "VLA-ADDBOX"
         "VLA-ADDCIRCLE"
         "VLA-ADDCONE"
         "VLA-ADDCUSTOMOBJECT"
         "VLA-ADDCYLINDER"
         "VLA-ADDDIM3POINTANGULAR"
         "VLA-ADDDIMALIGNED"
         "VLA-ADDDIMANGULAR"
         "VLA-ADDDIMDIAMETRIC"
         "VLA-ADDDIMORDINATE"
         "VLA-ADDDIMRADIAL"
         "VLA-ADDDIMROTATED"
         "VLA-ADDELLIPSE"
         "VLA-ADDELLIPTICALCONE"
         "VLA-ADDELLIPTICALCYLINDER"
         "VLA-ADDEXTRUDEDSOLID"
         "VLA-ADDEXTRUDEDSOLIDALONGPATH"
         "VLA-ADDFITPOINT"
         "VLA-ADDHATCH"
         "VLA-ADDITEMS"
         "VLA-ADDLEADER"
         "VLA-ADDLIGHTWEIGHTPOLYLINE"
         "VLA-ADDLINE"
         "VLA-ADDMENUITEM"
         "VLA-ADDMINSERTBLOCK"
         "VLA-ADDMLINE"
         "VLA-ADDMTEXT"
         "VLA-ADDOBJECT"
         "VLA-ADDPOINT"
         "VLA-ADDPOLYFACEMESH"
         "VLA-ADDPOLYLINE"
         "VLA-ADDPVIEWPORT"
         "VLA-ADDRASTER"
         "VLA-ADDRAY"
         "VLA-ADDREGION"
         "VLA-ADDREVOLVEDSOLID"
         "VLA-ADDSEPARATOR"
         "VLA-ADDSHAPE"
         "VLA-ADDSOLID"
         "VLA-ADDSPHERE"
         "VLA-ADDSPLINE"
         "VLA-ADDSUBMENU"
         "VLA-ADDTEXT"
         "VLA-ADDTOLERANCE"
         "VLA-ADDTOOLBARBUTTON"
         "VLA-ADDTORUS"
         "VLA-ADDTRACE"
         "VLA-ADDVERTEX"
         "VLA-ADDWEDGE"
         "VLA-ADDXLINE"
         "VLA-ADDXRECORD"
         "VLA-ANGLEFROMXAXIS"
         "VLA-ANGLETOREAL"
         "VLA-ANGLETOSTRING"
         "VLA-APPENDINNERLOOP"
         "VLA-APPENDITEMS"
         "VLA-APPENDOUTERLOOP"
         "VLA-APPENDVERTEX"
         "VLA-ARRAYPOLAR"
         "VLA-ARRAYRECTANGULAR"
         "VLA-ATTACHEXTERNALREFERENCE"
         "VLA-ATTACHTOOLBARTOFLYOUT"
         "VLA-AUDITINFO"
         "VLA-BIND"
         "VLA-BOOLEAN"
         "VLA-CHECKINTERFERENCE"
         "VLA-CLEAR"
         "VLA-CLIPBOUNDARY"
         "VLA-CLOSE"
         "VLA-COPY"
         "VLA-COPYFROM"
         "VLA-CREATETYPEDARRAY"
         "VLA-DELETE"
         "VLA-DELETEFITPOINT"
         "VLA-DELETEPROFILE"
         "VLA-DETACH"
         "VLA-DISPLAY"
         "VLA-DISPLAYPLOTPREVIEW"
         "VLA-DISTANCETOREAL"
         "VLA-DOCK"
         "VLA-ELEVATEORDER"
         "VLA-ENDUNDOMARK"
         "VLA-ERASE"
         "VLA-EVAL"
         "VLA-EVALUATE"
         "VLA-EXPLODE"
         "VLA-EXPORT"
         "VLA-EXPORTPROFILE"
         "VLA-FLOAT"
         "VLA-GET-ACTIVE"
         "VLA-GET-ACTIVEDIMSTYLE"
         "VLA-GET-ACTIVEDOCUMENT"
         "VLA-GET-ACTIVELAYER"
         "VLA-GET-ACTIVELAYOUT"
         "VLA-GET-ACTIVELINETYPE"
         "VLA-GET-ACTIVEPROFILE"
         "VLA-GET-ACTIVEPVIEWPORT"
         "VLA-GET-ACTIVESELECTIONSET"
         "VLA-GET-ACTIVESPACE"
         "VLA-GET-ACTIVETEXTSTYLE"
         "VLA-GET-ACTIVEUCS"
         "VLA-GET-ACTIVEVIEWPORT"
         "VLA-GET-ALIGNMENT"
         "VLA-GET-ALIGNMENTPOINTACQUISITION"
         "VLA-GET-ALLOWLONGSYMBOLNAMES"
         "VLA-GET-ALTFONTFILE"
         "VLA-GET-ALTROUNDDISTANCE"
         "VLA-GET-ALTSUPPRESSLEADINGZEROS"
         "VLA-GET-ALTSUPPRESSTRAILINGZEROS"
         "VLA-GET-ALTSUPPRESSZEROFEET"
         "VLA-GET-ALTSUPPRESSZEROINCHES"
         "VLA-GET-ALTTABLETMENUFILE"
         "VLA-GET-ALTTEXTPREFIX"
         "VLA-GET-ALTTEXTSUFFIX"
         "VLA-GET-ALTTOLERANCEPRECISION"
         "VLA-GET-ALTTOLERANCESUPPRESSLEADINGZEROS"
         "VLA-GET-ALTTOLERANCESUPPRESSTRAILINGZEROS"
         "VLA-GET-ALTTOLERANCESUPPRESSZEROFEET"
         "VLA-GET-ALTTOLERANCESUPPRESSZEROINCHES"
         "VLA-GET-ALTUNITS"
         "VLA-GET-ALTUNITSFORMAT"
         "VLA-GET-ALTUNITSPRECISION"
         "VLA-GET-ALTUNITSSCALE"
         "VLA-GET-ANGLE"
         "VLA-GET-ANGLEFORMAT"
         "VLA-GET-ANGLEVERTEX"
         "VLA-GET-ANNOTATION"
         "VLA-GET-APPLICATION"
         "VLA-GET-ARCLENGTH"
         "VLA-GET-ARCSMOOTHNESS"
         "VLA-GET-AREA"
         "VLA-GET-ARROWHEAD1BLOCK"
         "VLA-GET-ARROWHEAD1TYPE"
         "VLA-GET-ARROWHEAD2BLOCK"
         "VLA-GET-ARROWHEAD2TYPE"
         "VLA-GET-ARROWHEADBLOCK"
         "VLA-GET-ARROWHEADSIZE"
         "VLA-GET-ARROWHEADTYPE"
         "VLA-GET-ASSOCIATIVEHATCH"
         "VLA-GET-ATTACHMENTPOINT"
         "VLA-GET-AUTOAUDIT"
         "VLA-GET-AUTOSAVEINTERVAL"
         "VLA-GET-AUTOSAVEPATH"
         "VLA-GET-AUTOSNAPAPERTURE"
         "VLA-GET-AUTOSNAPAPERTURESIZE"
         "VLA-GET-AUTOSNAPMAGNET"
         "VLA-GET-AUTOSNAPMARKER"
         "VLA-GET-AUTOSNAPMARKERCOLOR"
         "VLA-GET-AUTOSNAPMARKERSIZE"
         "VLA-GET-AUTOSNAPTOOLTIP"
         "VLA-GET-AUTOTRACKINGVECCOLOR"
         "VLA-GET-AUTOTRACKTOOLTIP"
         "VLA-GET-BACKWARD"
         "VLA-GET-BASEPOINT"
         "VLA-GET-BATCHPLOTPROGRESS"
         "VLA-GET-BEEPONERROR"
         "VLA-GET-BIGFONTFILE"
         "VLA-GET-BLOCK"
         "VLA-GET-BLOCKS"
         "VLA-GET-BRIGHTNESS"
         "VLA-GET-CANONICALMEDIANAME"
         "VLA-GET-CAPTION"
         "VLA-GET-CEINSERTUNITS"
         "VLA-GET-CEINSERTUNITSACTION"
         "VLA-GET-CELOADPALETTE"
         "VLA-GET-CENTER"
         "VLA-GET-CENTERMARKSIZE"
         "VLA-GET-CENTERPLOT"
         "VLA-GET-CENTERTYPE"
         "VLA-GET-CENTROID"
         "VLA-GET-CHECK"
         "VLA-GET-CIRCUMFERENCE"
         "VLA-GET-CLIPPED"
         "VLA-GET-CLIPPINGENABLED"
         "VLA-GET-CLOSED"
         "VLA-GET-COLOR"
         "VLA-GET-COLUMNS"
         "VLA-GET-COLUMNSPACING"
         "VLA-GET-CONFIGFILE"
         "VLA-GET-CONFIGNAME"
         "VLA-GET-CONSTANT"
         "VLA-GET-CONSTANTWIDTH"
         "VLA-GET-CONTOURLINESPERSURFACE"
         "VLA-GET-CONTRAST"
         "VLA-GET-CONTROLPOINTS"
         "VLA-GET-COORDINATE"
         "VLA-GET-COORDINATES"
         "VLA-GET-COUNT"
         "VLA-GET-CREATEBACKUP"
         "VLA-GET-CURSORSIZE"
         "VLA-GET-CUSTOMDICTIONARY"
         "VLA-GET-CUSTOMSCALE"
         "VLA-GET-DATABASE"
         "VLA-GET-DECIMALSEPARATOR"
         "VLA-GET-DEFAULTINTERNETURL"
         "VLA-GET-DEFAULTOUTPUTDEVICE"
         "VLA-GET-DEFAULTPLOTSTYLEFORLAYERS"
         "VLA-GET-DEFAULTPLOTSTYLEFOROBJECTS"
         "VLA-GET-DEGREE"
         "VLA-GET-DELTA"
         "VLA-GET-DEMANDLOADARXAPP"
         "VLA-GET-DESCRIPTION"
         "VLA-GET-DIAMETER"
         "VLA-GET-DICTIONARIES"
         "VLA-GET-DIMENSIONLINECOLOR"
         "VLA-GET-DIMENSIONLINEEXTEND"
         "VLA-GET-DIMENSIONLINEWEIGHT"
         "VLA-GET-DIMLINE1SUPPRESS"
         "VLA-GET-DIMLINE2SUPPRESS"
         "VLA-GET-DIMLINEINSIDE"
         "VLA-GET-DIMLINESUPPRESS"
         "VLA-GET-DIMSTYLES"
         "VLA-GET-DIRECTION"
         "VLA-GET-DIRECTIONVECTOR"
         "VLA-GET-DISPLAY"
         "VLA-GET-DISPLAYDRAGGEDOBJECT"
         "VLA-GET-DISPLAYGRIPS"
         "VLA-GET-DISPLAYGRIPSWITHINBLOCKS"
         "VLA-GET-DISPLAYLAYOUTTABS"
         "VLA-GET-DISPLAYLOCKED"
         "VLA-GET-DISPLAYOLESCALE"
         "VLA-GET-DISPLAYSCREENMENU"
         "VLA-GET-DISPLAYSCROLLBARS"
         "VLA-GET-DISPLAYSILHOUETTE"
         "VLA-GET-DOCKEDVISIBLELINES"
         "VLA-GET-DOCKSTATUS"
         "VLA-GET-DOCUMENTS"
         "VLA-GET-DRAFTING"
         "VLA-GET-DRAWINGDIRECTION"
         "VLA-GET-DRIVERSPATH"
         "VLA-GET-ELEVATION"
         "VLA-GET-ELEVATIONMODELSPACE"
         "VLA-GET-ELEVATIONPAPERSPACE"
         "VLA-GET-ENABLE"
         "VLA-GET-ENABLESTARTUPDIALOG"
         "VLA-GET-ENDANGLE"
         "VLA-GET-ENDPARAMETER"
         "VLA-GET-ENDPOINT"
         "VLA-GET-ENDTANGENT"
         "VLA-GET-EXTENSIONLINECOLOR"
         "VLA-GET-EXTENSIONLINEEXTEND"
         "VLA-GET-EXTENSIONLINEOFFSET"
         "VLA-GET-EXTENSIONLINEWEIGHT"
         "VLA-GET-EXTLINE1ENDPOINT"
         "VLA-GET-EXTLINE1POINT"
         "VLA-GET-EXTLINE1STARTPOINT"
         "VLA-GET-EXTLINE1SUPPRESS"
         "VLA-GET-EXTLINE2ENDPOINT"
         "VLA-GET-EXTLINE2POINT"
         "VLA-GET-EXTLINE2STARTPOINT"
         "VLA-GET-EXTLINE2SUPPRESS"
         "VLA-GET-FADE"
         "VLA-GET-FIELDLENGTH"
         "VLA-GET-FILES"
         "VLA-GET-FIT"
         "VLA-GET-FITPOINTS"
         "VLA-GET-FITTOLERANCE"
         "VLA-GET-FLOATINGROWS"
         "VLA-GET-FLYOUT"
         "VLA-GET-FONTFILE"
         "VLA-GET-FONTFILEMAP"
         "VLA-GET-FORCELINEINSIDE"
         "VLA-GET-FRACTIONFORMAT"
         "VLA-GET-FREEZE"
         "VLA-GET-FULLCRCVALIDATION"
         "VLA-GET-FULLNAME"
         "VLA-GET-FULLSCREENTRACKINGVECTOR"
         "VLA-GET-GRAPHICSWINLAYOUTBACKGRNDCOLOR"
         "VLA-GET-GRAPHICSWINMODELBACKGRNDCOLOR"
         "VLA-GET-GRIDON"
         "VLA-GET-GRIPCOLORSELECTED"
         "VLA-GET-GRIPCOLORUNSELECTED"
         "VLA-GET-GRIPSIZE"
         "VLA-GET-GROUPS"
         "VLA-GET-HANDLE"
         "VLA-GET-HASATTRIBUTES"
         "VLA-GET-HASEXTENSIONDICTIONARY"
         "VLA-GET-HATCHSTYLE"
         "VLA-GET-HEIGHT"
         "VLA-GET-HELPFILEPATH"
         "VLA-GET-HELPSTRING"
         "VLA-GET-HISTORYLINES"
         "VLA-GET-HORIZONTALTEXTPOSITION"
         "VLA-GET-HWND"
         "VLA-GET-HYPERLINKDISPLAYCURSOR"
         "VLA-GET-HYPERLINKDISPLAYTOOLTIP"
         "VLA-GET-HYPERLINKS"
         "VLA-GET-IMAGEFILE"
         "VLA-GET-IMAGEFRAMEHIGHLIGHT"
         "VLA-GET-IMAGEHEIGHT"
         "VLA-GET-IMAGEVISIBILITY"
         "VLA-GET-IMAGEWIDTH"
         "VLA-GET-INCREMENTALSAVEPERCENT"
         "VLA-GET-INDEX"
         "VLA-GET-INSERTIONPOINT"
         "VLA-GET-INVISIBLE"
         "VLA-GET-ISLAYOUT"
         "VLA-GET-ISOPENWIDTH"
         "VLA-GET-ISPERIODIC"
         "VLA-GET-ISPLANAR"
         "VLA-GET-ISRATIONAL"
         "VLA-GET-ISXREF"
         "VLA-GET-KEYBOARDACCELERATOR"
         "VLA-GET-KEYBOARDPRIORITY"
         "VLA-GET-KNOTS"
         "VLA-GET-LABEL"
         "VLA-GET-LARGEBUTTONS"
         "VLA-GET-LASTHEIGHT"
         "VLA-GET-LAYER"
         "VLA-GET-LAYERON"
         "VLA-GET-LAYERS"
         "VLA-GET-LAYOUT"
         "VLA-GET-LAYOUTCREATEVIEWPORT"
         "VLA-GET-LAYOUTCROSSHAIRCOLOR"
         "VLA-GET-LAYOUTDISPLAYMARGINS"
         "VLA-GET-LAYOUTDISPLAYPAPER"
         "VLA-GET-LAYOUTDISPLAYPAPERSHADOW"
         "VLA-GET-LAYOUTS"
         "VLA-GET-LAYOUTSHOWPLOTSETUP"
         "VLA-GET-LEADERLENGTH"
         "VLA-GET-LEFT"
         "VLA-GET-LEGACYSTYLESHEET"
         "VLA-GET-LENGTH"
         "VLA-GET-LENSLENGTH"
         "VLA-GET-LICENSESERVER"
         "VLA-GET-LIMITS"
         "VLA-GET-LINEARSCALEFACTOR"
         "VLA-GET-LINESPACINGFACTOR"
         "VLA-GET-LINESPACINGSTYLE"
         "VLA-GET-LINETYPE"
         "VLA-GET-LINETYPEGENERATION"
         "VLA-GET-LINETYPES"
         "VLA-GET-LINETYPESCALE"
         "VLA-GET-LINEWEIGHT"
         "VLA-GET-LOCALEID"
         "VLA-GET-LOCK"
         "VLA-GET-LOGFILEON"
         "VLA-GET-LOGFILEPATH"
         "VLA-GET-LOWERLEFTCORNER"
         "VLA-GET-MACRO"
         "VLA-GET-MAINDICTIONARY"
         "VLA-GET-MAJORAXIS"
         "VLA-GET-MAJORRADIUS"
         "VLA-GET-MAXACTIVEVIEWPORTS"
         "VLA-GET-MAXAUTOCADWINDOW"
         "VLA-GET-MAXNUMOFSYMBOLS"
         "VLA-GET-MCLOSE"
         "VLA-GET-MDENSITY"
         "VLA-GET-MEASUREMENT"
         "VLA-GET-MEASUREMENTUNITS"
         "VLA-GET-MENUBAR"
         "VLA-GET-MENUFILE"
         "VLA-GET-MENUFILENAME"
         "VLA-GET-MENUGROUPS"
         "VLA-GET-MENUS"
         "VLA-GET-MINORAXIS"
         "VLA-GET-MINORRADIUS"
         "VLA-GET-MODE"
         "VLA-GET-MODELCROSSHAIRCOLOR"
         "VLA-GET-MODELSPACE"
         "VLA-GET-MODELTYPE"
         "VLA-GET-MOMENTOFINERTIA"
         "VLA-GET-MONOCHROMEVECTORS"
         "VLA-GET-MRUNUMBER"
         "VLA-GET-MSPACE"
         "VLA-GET-MVERTEXCOUNT"
         "VLA-GET-NAME"
         "VLA-GET-NAMENOMNEMONIC"
         "VLA-GET-NCLOSE"
         "VLA-GET-NDENSITY"
         "VLA-GET-NORMAL"
         "VLA-GET-NUMBEROFCONTROLPOINTS"
         "VLA-GET-NUMBEROFCOPIES"
         "VLA-GET-NUMBEROFFACES"
         "VLA-GET-NUMBEROFFITPOINTS"
         "VLA-GET-NUMBEROFLOOPS"
         "VLA-GET-NUMBEROFVERTICES"
         "VLA-GET-NVERTEXCOUNT"
         "VLA-GET-OBJECTARXPATH"
         "VLA-GET-OBJECTID"
         "VLA-GET-OBJECTNAME"
         "VLA-GET-OBJECTSNAPMODE"
         "VLA-GET-OBJECTSORTBYPLOTTING"
         "VLA-GET-OBJECTSORTBYPSOUTPUT"
         "VLA-GET-OBJECTSORTBYREDRAWS"
         "VLA-GET-OBJECTSORTBYREGENS"
         "VLA-GET-OBJECTSORTBYSELECTION"
         "VLA-GET-OBJECTSORTBYSNAP"
         "VLA-GET-OBLIQUEANGLE"
         "VLA-GET-OLELAUNCH"
         "VLA-GET-OLEQUALITY"
         "VLA-GET-ONMENUBAR"
         "VLA-GET-OPENSAVE"
         "VLA-GET-ORIGIN"
         "VLA-GET-ORTHOENABLED"
         "VLA-GET-ORTHOON"
         "VLA-GET-OUTPUT"
         "VLA-GET-PAPERSPACE"
         "VLA-GET-PAPERUNITS"
         "VLA-GET-PARENT"
         "VLA-GET-PATH"
         "VLA-GET-PATTERNANGLE"
         "VLA-GET-PATTERNDOUBLE"
         "VLA-GET-PATTERNNAME"
         "VLA-GET-PATTERNSCALE"
         "VLA-GET-PATTERNSPACE"
         "VLA-GET-PATTERNTYPE"
         "VLA-GET-PERIMETER"
         "VLA-GET-PICKADD"
         "VLA-GET-PICKAUTO"
         "VLA-GET-PICKBOXSIZE"
         "VLA-GET-PICKDRAG"
         "VLA-GET-PICKFIRST"
         "VLA-GET-PICKFIRSTSELECTIONSET"
         "VLA-GET-PICKGROUP"
         "VLA-GET-PLOT"
         "VLA-GET-PLOTCONFIGURATIONS"
         "VLA-GET-PLOTHIDDEN"
         "VLA-GET-PLOTLEGACY"
         "VLA-GET-PLOTORIGIN"
         "VLA-GET-PLOTPOLICYFORLEGACYDWGS"
         "VLA-GET-PLOTPOLICYFORNEWDWGS"
         "VLA-GET-PLOTROTATION"
         "VLA-GET-PLOTSTYLENAME"
         "VLA-GET-PLOTSTYLESHEET"
         "VLA-GET-PLOTTABLE"
         "VLA-GET-PLOTTYPE"
         "VLA-GET-PLOTVIEWPORTBORDERS"
         "VLA-GET-PLOTVIEWPORTSFIRST"
         "VLA-GET-PLOTWITHLINEWEIGHTS"
         "VLA-GET-PLOTWITHPLOTSTYLES"
         "VLA-GET-POLARTRACKINGVECTOR"
         "VLA-GET-POSTSCRIPTPROLOGFILE"
         "VLA-GET-PREFERENCES"
         "VLA-GET-PRESET"
         "VLA-GET-PRIMARYUNITSPRECISION"
         "VLA-GET-PRINCIPALDIRECTIONS"
         "VLA-GET-PRINCIPALMOMENTS"
         "VLA-GET-PRINTERCONFIGPATH"
         "VLA-GET-PRINTERDESCPATH"
         "VLA-GET-PRINTERPAPERSIZEALERT"
         "VLA-GET-PRINTERSPOOLALERT"
         "VLA-GET-PRINTERSTYLESHEETPATH"
         "VLA-GET-PRINTFILE"
         "VLA-GET-PRINTSPOOLERPATH"
         "VLA-GET-PRINTSPOOLEXECUTABLE"
         "VLA-GET-PRODUCTOFINERTIA"
         "VLA-GET-PROFILES"
         "VLA-GET-PROMPTSTRING"
         "VLA-GET-PROXYIMAGE"
         "VLA-GET-QUIETERRORMODE"
         "VLA-GET-RADIIOFGYRATION"
         "VLA-GET-RADIUS"
         "VLA-GET-RADIUSRATIO"
         "VLA-GET-READONLY"
         "VLA-GET-REGISTEREDAPPLICATIONS"
         "VLA-GET-REMOVEHIDDENLINES"
         "VLA-GET-RENDERSMOOTHNESS"
         "VLA-GET-ROTATION"
         "VLA-GET-ROUNDDISTANCE"
         "VLA-GET-ROWS"
         "VLA-GET-ROWSPACING"
         "VLA-GET-SAVEASTYPE"
         "VLA-GET-SAVED"
         "VLA-GET-SAVEPREVIEWTHUMBNAIL"
         "VLA-GET-SCALEFACTOR"
         "VLA-GET-SCALELINEWEIGHTS"
         "VLA-GET-SECONDPOINT"
         "VLA-GET-SEGMENTPERPOLYLINE"
         "VLA-GET-SELECTION"
         "VLA-GET-SELECTIONSETS"
         "VLA-GET-SHORTCUTMENU"
         "VLA-GET-SHOWPLOTSTYLES"
         "VLA-GET-SHOWPROXYDIALOGBOX"
         "VLA-GET-SHOWRASTERIMAGE"
         "VLA-GET-SHOWWARNINGMESSAGES"
         "VLA-GET-SINGLEDOCUMENTMODE"
         "VLA-GET-SNAPBASEPOINT"
         "VLA-GET-SNAPON"
         "VLA-GET-SNAPROTATIONANGLE"
         "VLA-GET-SOLIDCHECK"
         "VLA-GET-SOLIDFILL"
         "VLA-GET-STANDARDSCALE"
         "VLA-GET-STARTANGLE"
         "VLA-GET-STARTPARAMETER"
         "VLA-GET-STARTPOINT"
         "VLA-GET-STARTTANGENT"
         "VLA-GET-STATUSID"
         "VLA-GET-STORESQLINDEX"
         "VLA-GET-STYLENAME"
         "VLA-GET-STYLESHEET"
         "VLA-GET-SUBMENU"
         "VLA-GET-SUPPORTPATH"
         "VLA-GET-SUPPRESSLEADINGZEROS"
         "VLA-GET-SUPPRESSTRAILINGZEROS"
         "VLA-GET-SUPPRESSZEROFEET"
         "VLA-GET-SUPPRESSZEROINCHES"
         "VLA-GET-SYSTEM"
         "VLA-GET-TABLESREADONLY"
         "VLA-GET-TABORDER"
         "VLA-GET-TAGSTRING"
         "VLA-GET-TARGET"
         "VLA-GET-TEMPFILEEXTENSION"
         "VLA-GET-TEMPFILEPATH"
         "VLA-GET-TEMPLATEDWGPATH"
         "VLA-GET-TEMPXREFPATH"
         "VLA-GET-TEXTALIGNMENTPOINT"
         "VLA-GET-TEXTCOLOR"
         "VLA-GET-TEXTEDITOR"
         "VLA-GET-TEXTFONT"
         "VLA-GET-TEXTFONTSIZE"
         "VLA-GET-TEXTFONTSTYLE"
         "VLA-GET-TEXTFRAMEDISPLAY"
         "VLA-GET-TEXTGAP"
         "VLA-GET-TEXTGENERATIONFLAG"
         "VLA-GET-TEXTHEIGHT"
         "VLA-GET-TEXTINSIDE"
         "VLA-GET-TEXTINSIDEALIGN"
         "VLA-GET-TEXTMOVEMENT"
         "VLA-GET-TEXTOUTSIDEALIGN"
         "VLA-GET-TEXTOVERRIDE"
         "VLA-GET-TEXTPOSITION"
         "VLA-GET-TEXTPRECISION"
         "VLA-GET-TEXTPREFIX"
         "VLA-GET-TEXTROTATION"
         "VLA-GET-TEXTSTRING"
         "VLA-GET-TEXTSTYLE"
         "VLA-GET-TEXTSTYLES"
         "VLA-GET-TEXTSUFFIX"
         "VLA-GET-TEXTUREMAPPATH"
         "VLA-GET-TEXTWINBACKGRNDCOLOR"
         "VLA-GET-TEXTWINTEXTCOLOR"
         "VLA-GET-THICKNESS"
         "VLA-GET-TOLERANCEDISPLAY"
         "VLA-GET-TOLERANCEHEIGHTSCALE"
         "VLA-GET-TOLERANCEJUSTIFICATION"
         "VLA-GET-TOLERANCELOWERLIMIT"
         "VLA-GET-TOLERANCEPRECISION"
         "VLA-GET-TOLERANCESUPPRESSLEADINGZEROS"
         "VLA-GET-TOLERANCESUPPRESSTRAILINGZEROS"
         "VLA-GET-TOLERANCESUPPRESSZEROFEET"
         "VLA-GET-TOLERANCESUPPRESSZEROINCHES"
         "VLA-GET-TOLERANCEUPPERLIMIT"
         "VLA-GET-TOOLBARS"
         "VLA-GET-TOP"
         "VLA-GET-TOTALANGLE"
         "VLA-GET-TRANSLATEIDS"
         "VLA-GET-TRANSPARENCY"
         "VLA-GET-TRUECOLORIMAGES"
         "VLA-GET-TWISTANGLE"
         "VLA-GET-TYPE"
         "VLA-GET-UCSICONATORIGIN"
         "VLA-GET-UCSICONON"
         "VLA-GET-UCSPERVIEWPORT"
         "VLA-GET-UNITSFORMAT"
         "VLA-GET-UPPERRIGHTCORNER"
         "VLA-GET-UPSIDEDOWN"
         "VLA-GET-URL"
         "VLA-GET-URLDESCRIPTION"
         "VLA-GET-USER"
         "VLA-GET-USERCOORDINATESYSTEMS"
         "VLA-GET-USESTANDARDSCALE"
         "VLA-GET-UTILITY"
         "VLA-GET-VBE"
         "VLA-GET-VERIFY"
         "VLA-GET-VERSION"
         "VLA-GET-VERTICALTEXTPOSITION"
         "VLA-GET-VIEWPORTDEFAULT"
         "VLA-GET-VIEWPORTON"
         "VLA-GET-VIEWPORTS"
         "VLA-GET-VIEWS"
         "VLA-GET-VIEWTOPLOT"
         "VLA-GET-VISIBILITYEDGE1"
         "VLA-GET-VISIBILITYEDGE2"
         "VLA-GET-VISIBILITYEDGE3"
         "VLA-GET-VISIBILITYEDGE4"
         "VLA-GET-VISIBLE"
         "VLA-GET-VOLUME"
         "VLA-GET-WEIGHTS"
         "VLA-GET-WIDTH"
         "VLA-GET-WINDOWSTATE"
         "VLA-GET-WINDOWTITLE"
         "VLA-GET-WORKSPACEPATH"
         "VLA-GET-XREFDATABASE"
         "VLA-GET-XREFDEMANDLOAD"
         "VLA-GET-XREFEDIT"
         "VLA-GET-XREFFADEINTENSITY"
         "VLA-GET-XREFLAYERVISIBILITY"
         "VLA-GET-XSCALEFACTOR"
         "VLA-GET-XVECTOR"
         "VLA-GET-YSCALEFACTOR"
         "VLA-GET-YVECTOR"
         "VLA-GET-ZSCALEFACTOR"
         "VLA-GETANGLE"
         "VLA-GETATTRIBUTES"
         "VLA-GETBITMAPS"
         "VLA-GETBOUNDINGBOX"
         "VLA-GETBULGE"
         "VLA-GETCONSTANTATTRIBUTES"
         "VLA-GETCONTROLPOINT"
         "VLA-GETCORNER"
         "VLA-GETCUSTOMSCALE"
         "VLA-GETDISTANCE"
         "VLA-GETENTITY"
         "VLA-GETEXTENSIONDICTIONARY"
         "VLA-GETFITPOINT"
         "VLA-GETFONT"
         "VLA-GETGRIDSPACING"
         "VLA-GETINPUT"
         "VLA-GETINTEGER"
         "VLA-GETINTERFACEOBJECT"
         "VLA-GETINVISIBLEEDGE"
         "VLA-GETKEYWORD"
         "VLA-GETLOOPAT"
         "VLA-GETNAME"
         "VLA-GETOBJECT"
         "VLA-GETORIENTATION"
         "VLA-GETPAPERMARGINS"
         "VLA-GETPAPERSIZE"
         "VLA-GETPOINT"
         "VLA-GETPROJECTFILEPATH"
         "VLA-GETREAL"
         "VLA-GETSNAPSPACING"
         "VLA-GETSTRING"
         "VLA-GETSUBENTITY"
         "VLA-GETUCSMATRIX"
         "VLA-GETVARIABLE"
         "VLA-GETWEIGHT"
         "VLA-GETWIDTH"
         "VLA-GETWINDOWTOPLOT"
         "VLA-GETXDATA"
         "VLA-GETXRECORDDATA"
         "VLA-HANDLETOOBJECT"
         "VLA-HIGHLIGHT"
         "VLA-IMPORT"
         "VLA-IMPORTPROFILE"
         "VLA-INITIALIZEUSERINPUT"
         "VLA-INSERTBLOCK"
         "VLA-INSERTINMENUBAR"
         "VLA-INSERTLOOPAT"
         "VLA-INSERTMENUINMENUBAR"
         "VLA-INTERSECTWITH"
         "VLA-ITEM"
         "VLA-LISTADS"
         "VLA-LISTARX"
         "VLA-LOAD"
         "VLA-LOADADS"
         "VLA-LOADARX"
         "VLA-LOADDVB"
         "VLA-LOADSHAPEFILE"
         "VLA-MIRROR"
         "VLA-MIRROR3D"
         "VLA-MODIFIED"
         "VLA-MOVE"
         "VLA-NEW"
         "VLA-OBJECTIDTOOBJECT"
         "VLA-OFFSET"
         "VLA-OPEN"
         "VLA-PLOTTODEVICE"
         "VLA-PLOTTOFILE"
         "VLA-POLARPOINT"
         "VLA-PROMPT"
         "VLA-PURGEALL"
         "VLA-PURGEFITDATA"
         "VLA-PUT-ACTIVEDIMSTYLE"
         "VLA-PUT-ACTIVEDOCUMENT"
         "VLA-PUT-ACTIVELAYER"
         "VLA-PUT-ACTIVELAYOUT"
         "VLA-PUT-ACTIVELINETYPE"
         "VLA-PUT-ACTIVEPROFILE"
         "VLA-PUT-ACTIVEPVIEWPORT"
         "VLA-PUT-ACTIVESPACE"
         "VLA-PUT-ACTIVETEXTSTYLE"
         "VLA-PUT-ACTIVEUCS"
         "VLA-PUT-ACTIVEVIEWPORT"
         "VLA-PUT-ALIGNMENT"
         "VLA-PUT-ALIGNMENTPOINTACQUISITION"
         "VLA-PUT-ALLOWLONGSYMBOLNAMES"
         "VLA-PUT-ALTFONTFILE"
         "VLA-PUT-ALTROUNDDISTANCE"
         "VLA-PUT-ALTSUPPRESSLEADINGZEROS"
         "VLA-PUT-ALTSUPPRESSTRAILINGZEROS"
         "VLA-PUT-ALTSUPPRESSZEROFEET"
         "VLA-PUT-ALTSUPPRESSZEROINCHES"
         "VLA-PUT-ALTTABLETMENUFILE"
         "VLA-PUT-ALTTEXTPREFIX"
         "VLA-PUT-ALTTEXTSUFFIX"
         "VLA-PUT-ALTTOLERANCEPRECISION"
         "VLA-PUT-ALTTOLERANCESUPPRESSLEADINGZEROS"
         "VLA-PUT-ALTTOLERANCESUPPRESSTRAILINGZEROS"
         "VLA-PUT-ALTTOLERANCESUPPRESSZEROFEET"
         "VLA-PUT-ALTTOLERANCESUPPRESSZEROINCHES"
         "VLA-PUT-ALTUNITS"
         "VLA-PUT-ALTUNITSFORMAT"
         "VLA-PUT-ALTUNITSPRECISION"
         "VLA-PUT-ALTUNITSSCALE"
         "VLA-PUT-ANGLEFORMAT"
         "VLA-PUT-ANGLEVERTEX"
         "VLA-PUT-ANNOTATION"
         "VLA-PUT-ARCSMOOTHNESS"
         "VLA-PUT-AREA"
         "VLA-PUT-ARROWHEAD1BLOCK"
         "VLA-PUT-ARROWHEAD1TYPE"
         "VLA-PUT-ARROWHEAD2BLOCK"
         "VLA-PUT-ARROWHEAD2TYPE"
         "VLA-PUT-ARROWHEADBLOCK"
         "VLA-PUT-ARROWHEADSIZE"
         "VLA-PUT-ARROWHEADTYPE"
         "VLA-PUT-ASSOCIATIVEHATCH"
         "VLA-PUT-ATTACHMENTPOINT"
         "VLA-PUT-AUTOAUDIT"
         "VLA-PUT-AUTOSAVEINTERVAL"
         "VLA-PUT-AUTOSAVEPATH"
         "VLA-PUT-AUTOSNAPAPERTURE"
         "VLA-PUT-AUTOSNAPAPERTURESIZE"
         "VLA-PUT-AUTOSNAPMAGNET"
         "VLA-PUT-AUTOSNAPMARKER"
         "VLA-PUT-AUTOSNAPMARKERCOLOR"
         "VLA-PUT-AUTOSNAPMARKERSIZE"
         "VLA-PUT-AUTOSNAPTOOLTIP"
         "VLA-PUT-AUTOTRACKINGVECCOLOR"
         "VLA-PUT-AUTOTRACKTOOLTIP"
         "VLA-PUT-BACKWARD"
         "VLA-PUT-BASEPOINT"
         "VLA-PUT-BATCHPLOTPROGRESS"
         "VLA-PUT-BEEPONERROR"
         "VLA-PUT-BIGFONTFILE"
         "VLA-PUT-BRIGHTNESS"
         "VLA-PUT-CANONICALMEDIANAME"
         "VLA-PUT-CEINSERTUNITS"
         "VLA-PUT-CEINSERTUNITSACTION"
         "VLA-PUT-CELOADPALETTE"
         "VLA-PUT-CENTER"
         "VLA-PUT-CENTERMARKSIZE"
         "VLA-PUT-CENTERPLOT"
         "VLA-PUT-CENTERTYPE"
         "VLA-PUT-CHECK"
         "VLA-PUT-CIRCUMFERENCE"
         "VLA-PUT-CLIPPINGENABLED"
         "VLA-PUT-CLOSED"
         "VLA-PUT-COLOR"
         "VLA-PUT-COLUMNS"
         "VLA-PUT-COLUMNSPACING"
         "VLA-PUT-CONFIGNAME"
         "VLA-PUT-CONSTANT"
         "VLA-PUT-CONSTANTWIDTH"
         "VLA-PUT-CONTOURLINESPERSURFACE"
         "VLA-PUT-CONTRAST"
         "VLA-PUT-CONTROLPOINTS"
         "VLA-PUT-COORDINATE"
         "VLA-PUT-COORDINATES"
         "VLA-PUT-CREATEBACKUP"
         "VLA-PUT-CURSORSIZE"
         "VLA-PUT-CUSTOMDICTIONARY"
         "VLA-PUT-CUSTOMSCALE"
         "VLA-PUT-DECIMALSEPARATOR"
         "VLA-PUT-DEFAULTINTERNETURL"
         "VLA-PUT-DEFAULTOUTPUTDEVICE"
         "VLA-PUT-DEFAULTPLOTSTYLEFORLAYERS"
         "VLA-PUT-DEFAULTPLOTSTYLEFOROBJECTS"
         "VLA-PUT-DEMANDLOADARXAPP"
         "VLA-PUT-DESCRIPTION"
         "VLA-PUT-DIAMETER"
         "VLA-PUT-DIMENSIONLINECOLOR"
         "VLA-PUT-DIMENSIONLINEEXTEND"
         "VLA-PUT-DIMENSIONLINEWEIGHT"
         "VLA-PUT-DIMLINE1SUPPRESS"
         "VLA-PUT-DIMLINE2SUPPRESS"
         "VLA-PUT-DIMLINEINSIDE"
         "VLA-PUT-DIMLINESUPPRESS"
         "VLA-PUT-DIRECTION"
         "VLA-PUT-DIRECTIONVECTOR"
         "VLA-PUT-DISPLAYDRAGGEDOBJECT"
         "VLA-PUT-DISPLAYGRIPS"
         "VLA-PUT-DISPLAYGRIPSWITHINBLOCKS"
         "VLA-PUT-DISPLAYLAYOUTTABS"
         "VLA-PUT-DISPLAYLOCKED"
         "VLA-PUT-DISPLAYOLESCALE"
         "VLA-PUT-DISPLAYSCREENMENU"
         "VLA-PUT-DISPLAYSCROLLBARS"
         "VLA-PUT-DISPLAYSILHOUETTE"
         "VLA-PUT-DOCKEDVISIBLELINES"
         "VLA-PUT-DRAWINGDIRECTION"
         "VLA-PUT-DRIVERSPATH"
         "VLA-PUT-ELEVATION"
         "VLA-PUT-ELEVATIONMODELSPACE"
         "VLA-PUT-ELEVATIONPAPERSPACE"
         "VLA-PUT-ENABLE"
         "VLA-PUT-ENABLESTARTUPDIALOG"
         "VLA-PUT-ENDANGLE"
         "VLA-PUT-ENDPARAMETER"
         "VLA-PUT-ENDPOINT"
         "VLA-PUT-ENDTANGENT"
         "VLA-PUT-EXTENSIONLINECOLOR"
         "VLA-PUT-EXTENSIONLINEEXTEND"
         "VLA-PUT-EXTENSIONLINEOFFSET"
         "VLA-PUT-EXTENSIONLINEWEIGHT"
         "VLA-PUT-EXTLINE1ENDPOINT"
         "VLA-PUT-EXTLINE1POINT"
         "VLA-PUT-EXTLINE1STARTPOINT"
         "VLA-PUT-EXTLINE1SUPPRESS"
         "VLA-PUT-EXTLINE2ENDPOINT"
         "VLA-PUT-EXTLINE2POINT"
         "VLA-PUT-EXTLINE2STARTPOINT"
         "VLA-PUT-EXTLINE2SUPPRESS"
         "VLA-PUT-FADE"
         "VLA-PUT-FIELDLENGTH"
         "VLA-PUT-FIT"
         "VLA-PUT-FITPOINTS"
         "VLA-PUT-FITTOLERANCE"
         "VLA-PUT-FLOATINGROWS"
         "VLA-PUT-FONTFILE"
         "VLA-PUT-FONTFILEMAP"
         "VLA-PUT-FORCELINEINSIDE"
         "VLA-PUT-FRACTIONFORMAT"
         "VLA-PUT-FREEZE"
         "VLA-PUT-FULLCRCVALIDATION"
         "VLA-PUT-FULLSCREENTRACKINGVECTOR"
         "VLA-PUT-GRAPHICSWINLAYOUTBACKGRNDCOLOR"
         "VLA-PUT-GRAPHICSWINMODELBACKGRNDCOLOR"
         "VLA-PUT-GRIDON"
         "VLA-PUT-GRIPCOLORSELECTED"
         "VLA-PUT-GRIPCOLORUNSELECTED"
         "VLA-PUT-GRIPSIZE"
         "VLA-PUT-HATCHSTYLE"
         "VLA-PUT-HEIGHT"
         "VLA-PUT-HELPFILEPATH"
         "VLA-PUT-HELPSTRING"
         "VLA-PUT-HISTORYLINES"
         "VLA-PUT-HORIZONTALTEXTPOSITION"
         "VLA-PUT-HYPERLINKDISPLAYCURSOR"
         "VLA-PUT-HYPERLINKDISPLAYTOOLTIP"
         "VLA-PUT-IMAGEFILE"
         "VLA-PUT-IMAGEFRAMEHIGHLIGHT"
         "VLA-PUT-IMAGEHEIGHT"
         "VLA-PUT-IMAGEVISIBILITY"
         "VLA-PUT-IMAGEWIDTH"
         "VLA-PUT-INCREMENTALSAVEPERCENT"
         "VLA-PUT-INSERTIONPOINT"
         "VLA-PUT-INVISIBLE"
         "VLA-PUT-ISOPENWIDTH"
         "VLA-PUT-KEYBOARDACCELERATOR"
         "VLA-PUT-KEYBOARDPRIORITY"
         "VLA-PUT-KNOTS"
         "VLA-PUT-LABEL"
         "VLA-PUT-LARGEBUTTONS"
         "VLA-PUT-LASTHEIGHT"
         "VLA-PUT-LAYER"
         "VLA-PUT-LAYERON"
         "VLA-PUT-LAYOUTCREATEVIEWPORT"
         "VLA-PUT-LAYOUTCROSSHAIRCOLOR"
         "VLA-PUT-LAYOUTDISPLAYMARGINS"
         "VLA-PUT-LAYOUTDISPLAYPAPER"
         "VLA-PUT-LAYOUTDISPLAYPAPERSHADOW"
         "VLA-PUT-LAYOUTSHOWPLOTSETUP"
         "VLA-PUT-LEADERLENGTH"
         "VLA-PUT-LEFT"
         "VLA-PUT-LEGACYSTYLESHEET"
         "VLA-PUT-LENSLENGTH"
         "VLA-PUT-LIMITS"
         "VLA-PUT-LINEARSCALEFACTOR"
         "VLA-PUT-LINESPACINGFACTOR"
         "VLA-PUT-LINESPACINGSTYLE"
         "VLA-PUT-LINETYPE"
         "VLA-PUT-LINETYPEGENERATION"
         "VLA-PUT-LINETYPESCALE"
         "VLA-PUT-LINEWEIGHT"
         "VLA-PUT-LOCK"
         "VLA-PUT-LOGFILEON"
         "VLA-PUT-LOGFILEPATH"
         "VLA-PUT-MACRO"
         "VLA-PUT-MAINDICTIONARY"
         "VLA-PUT-MAJORAXIS"
         "VLA-PUT-MAJORRADIUS"
         "VLA-PUT-MAXACTIVEVIEWPORTS"
         "VLA-PUT-MAXAUTOCADWINDOW"
         "VLA-PUT-MAXNUMOFSYMBOLS"
         "VLA-PUT-MCLOSE"
         "VLA-PUT-MDENSITY"
         "VLA-PUT-MEASUREMENTUNITS"
         "VLA-PUT-MENUFILE"
         "VLA-PUT-MINORRADIUS"
         "VLA-PUT-MODE"
         "VLA-PUT-MODELCROSSHAIRCOLOR"
         "VLA-PUT-MODELTYPE"
         "VLA-PUT-MONOCHROMEVECTORS"
         "VLA-PUT-MRUNUMBER"
         "VLA-PUT-MSPACE"
         "VLA-PUT-NAME"
         "VLA-PUT-NCLOSE"
         "VLA-PUT-NDENSITY"
         "VLA-PUT-NORMAL"
         "VLA-PUT-NUMBEROFCOPIES"
         "VLA-PUT-OBJECTARXPATH"
         "VLA-PUT-OBJECTSNAPMODE"
         "VLA-PUT-OBJECTSORTBYPLOTTING"
         "VLA-PUT-OBJECTSORTBYPSOUTPUT"
         "VLA-PUT-OBJECTSORTBYREDRAWS"
         "VLA-PUT-OBJECTSORTBYREGENS"
         "VLA-PUT-OBJECTSORTBYSELECTION"
         "VLA-PUT-OBJECTSORTBYSNAP"
         "VLA-PUT-OBLIQUEANGLE"
         "VLA-PUT-OLELAUNCH"
         "VLA-PUT-OLEQUALITY"
         "VLA-PUT-ORIGIN"
         "VLA-PUT-ORTHOENABLED"
         "VLA-PUT-ORTHOON"
         "VLA-PUT-PAPERUNITS"
         "VLA-PUT-PATH"
         "VLA-PUT-PATTERNANGLE"
         "VLA-PUT-PATTERNDOUBLE"
         "VLA-PUT-PATTERNSCALE"
         "VLA-PUT-PATTERNSPACE"
         "VLA-PUT-PICKADD"
         "VLA-PUT-PICKAUTO"
         "VLA-PUT-PICKBOXSIZE"
         "VLA-PUT-PICKDRAG"
         "VLA-PUT-PICKFIRST"
         "VLA-PUT-PICKGROUP"
         "VLA-PUT-PLOTHIDDEN"
         "VLA-PUT-PLOTLEGACY"
         "VLA-PUT-PLOTORIGIN"
         "VLA-PUT-PLOTPOLICYFORLEGACYDWGS"
         "VLA-PUT-PLOTPOLICYFORNEWDWGS"
         "VLA-PUT-PLOTROTATION"
         "VLA-PUT-PLOTSTYLENAME"
         "VLA-PUT-PLOTSTYLESHEET"
         "VLA-PUT-PLOTTABLE"
         "VLA-PUT-PLOTTYPE"
         "VLA-PUT-PLOTVIEWPORTBORDERS"
         "VLA-PUT-PLOTVIEWPORTSFIRST"
         "VLA-PUT-PLOTWITHLINEWEIGHTS"
         "VLA-PUT-PLOTWITHPLOTSTYLES"
         "VLA-PUT-POLARTRACKINGVECTOR"
         "VLA-PUT-POSTSCRIPTPROLOGFILE"
         "VLA-PUT-PRESET"
         "VLA-PUT-PRIMARYUNITSPRECISION"
         "VLA-PUT-PRINTERCONFIGPATH"
         "VLA-PUT-PRINTERDESCPATH"
         "VLA-PUT-PRINTERPAPERSIZEALERT"
         "VLA-PUT-PRINTERSPOOLALERT"
         "VLA-PUT-PRINTERSTYLESHEETPATH"
         "VLA-PUT-PRINTFILE"
         "VLA-PUT-PRINTSPOOLERPATH"
         "VLA-PUT-PRINTSPOOLEXECUTABLE"
         "VLA-PUT-PROMPTSTRING"
         "VLA-PUT-PROXYIMAGE"
         "VLA-PUT-QUIETERRORMODE"
         "VLA-PUT-RADIUS"
         "VLA-PUT-RADIUSRATIO"
         "VLA-PUT-REMOVEHIDDENLINES"
         "VLA-PUT-RENDERSMOOTHNESS"
         "VLA-PUT-ROTATION"
         "VLA-PUT-ROUNDDISTANCE"
         "VLA-PUT-ROWS"
         "VLA-PUT-ROWSPACING"
         "VLA-PUT-SAVEASTYPE"
         "VLA-PUT-SAVEPREVIEWTHUMBNAIL"
         "VLA-PUT-SCALEFACTOR"
         "VLA-PUT-SCALELINEWEIGHTS"
         "VLA-PUT-SECONDPOINT"
         "VLA-PUT-SEGMENTPERPOLYLINE"
         "VLA-PUT-SHOWPLOTSTYLES"
         "VLA-PUT-SHOWPROXYDIALOGBOX"
         "VLA-PUT-SHOWRASTERIMAGE"
         "VLA-PUT-SHOWWARNINGMESSAGES"
         "VLA-PUT-SINGLEDOCUMENTMODE"
         "VLA-PUT-SNAPBASEPOINT"
         "VLA-PUT-SNAPON"
         "VLA-PUT-SNAPROTATIONANGLE"
         "VLA-PUT-SOLIDCHECK"
         "VLA-PUT-SOLIDFILL"
         "VLA-PUT-STANDARDSCALE"
         "VLA-PUT-STARTANGLE"
         "VLA-PUT-STARTPARAMETER"
         "VLA-PUT-STARTPOINT"
         "VLA-PUT-STARTTANGENT"
         "VLA-PUT-STORESQLINDEX"
         "VLA-PUT-STYLENAME"
         "VLA-PUT-STYLESHEET"
         "VLA-PUT-SUPPORTPATH"
         "VLA-PUT-SUPPRESSLEADINGZEROS"
         "VLA-PUT-SUPPRESSTRAILINGZEROS"
         "VLA-PUT-SUPPRESSZEROFEET"
         "VLA-PUT-SUPPRESSZEROINCHES"
         "VLA-PUT-TABLESREADONLY"
         "VLA-PUT-TABORDER"
         "VLA-PUT-TAGSTRING"
         "VLA-PUT-TARGET"
         "VLA-PUT-TEMPFILEEXTENSION"
         "VLA-PUT-TEMPFILEPATH"
         "VLA-PUT-TEMPLATEDWGPATH"
         "VLA-PUT-TEMPXREFPATH"
         "VLA-PUT-TEXTALIGNMENTPOINT"
         "VLA-PUT-TEXTCOLOR"
         "VLA-PUT-TEXTEDITOR"
         "VLA-PUT-TEXTFONT"
         "VLA-PUT-TEXTFONTSIZE"
         "VLA-PUT-TEXTFONTSTYLE"
         "VLA-PUT-TEXTFRAMEDISPLAY"
         "VLA-PUT-TEXTGAP"
         "VLA-PUT-TEXTGENERATIONFLAG"
         "VLA-PUT-TEXTHEIGHT"
         "VLA-PUT-TEXTINSIDE"
         "VLA-PUT-TEXTINSIDEALIGN"
         "VLA-PUT-TEXTMOVEMENT"
         "VLA-PUT-TEXTOUTSIDEALIGN"
         "VLA-PUT-TEXTOVERRIDE"
         "VLA-PUT-TEXTPOSITION"
         "VLA-PUT-TEXTPRECISION"
         "VLA-PUT-TEXTPREFIX"
         "VLA-PUT-TEXTROTATION"
         "VLA-PUT-TEXTSTRING"
         "VLA-PUT-TEXTSTYLE"
         "VLA-PUT-TEXTSUFFIX"
         "VLA-PUT-TEXTUREMAPPATH"
         "VLA-PUT-TEXTWINBACKGRNDCOLOR"
         "VLA-PUT-TEXTWINTEXTCOLOR"
         "VLA-PUT-THICKNESS"
         "VLA-PUT-TOLERANCEDISPLAY"
         "VLA-PUT-TOLERANCEHEIGHTSCALE"
         "VLA-PUT-TOLERANCEJUSTIFICATION"
         "VLA-PUT-TOLERANCELOWERLIMIT"
         "VLA-PUT-TOLERANCEPRECISION"
         "VLA-PUT-TOLERANCESUPPRESSLEADINGZEROS"
         "VLA-PUT-TOLERANCESUPPRESSTRAILINGZEROS"
         "VLA-PUT-TOLERANCESUPPRESSZEROFEET"
         "VLA-PUT-TOLERANCESUPPRESSZEROINCHES"
         "VLA-PUT-TOLERANCEUPPERLIMIT"
         "VLA-PUT-TOP"
         "VLA-PUT-TRANSLATEIDS"
         "VLA-PUT-TRANSPARENCY"
         "VLA-PUT-TRUECOLORIMAGES"
         "VLA-PUT-TWISTANGLE"
         "VLA-PUT-TYPE"
         "VLA-PUT-UCSICONATORIGIN"
         "VLA-PUT-UCSICONON"
         "VLA-PUT-UCSPERVIEWPORT"
         "VLA-PUT-UNITSFORMAT"
         "VLA-PUT-UPSIDEDOWN"
         "VLA-PUT-URL"
         "VLA-PUT-URLDESCRIPTION"
         "VLA-PUT-USESTANDARDSCALE"
         "VLA-PUT-VERIFY"
         "VLA-PUT-VERTICALTEXTPOSITION"
         "VLA-PUT-VIEWPORTDEFAULT"
         "VLA-PUT-VIEWPORTON"
         "VLA-PUT-VIEWTOPLOT"
         "VLA-PUT-VISIBILITYEDGE1"
         "VLA-PUT-VISIBILITYEDGE2"
         "VLA-PUT-VISIBILITYEDGE3"
         "VLA-PUT-VISIBILITYEDGE4"
         "VLA-PUT-VISIBLE"
         "VLA-PUT-WEIGHTS"
         "VLA-PUT-WIDTH"
         "VLA-PUT-WINDOWSTATE"
         "VLA-PUT-WORKSPACEPATH"
         "VLA-PUT-XREFDEMANDLOAD"
         "VLA-PUT-XREFEDIT"
         "VLA-PUT-XREFFADEINTENSITY"
         "VLA-PUT-XREFLAYERVISIBILITY"
         "VLA-PUT-XSCALEFACTOR"
         "VLA-PUT-XVECTOR"
         "VLA-PUT-YSCALEFACTOR"
         "VLA-PUT-YVECTOR"
         "VLA-PUT-ZSCALEFACTOR"
         "VLA-QUIT"
         "VLA-REALTOSTRING"
         "VLA-REGEN"
         "VLA-RELOAD"
         "VLA-REMOVE"
         "VLA-REMOVEFROMMENUBAR"
         "VLA-REMOVEITEMS"
         "VLA-REMOVEMENUFROMMENUBAR"
         "VLA-RENAME"
         "VLA-REPLACE"
         "VLA-RESETPROFILE"
         "VLA-REVERSE"
         "VLA-ROTATE"
         "VLA-ROTATE3D"
         "VLA-RUNMACRO"
         "VLA-SAVE"
         "VLA-SAVEAS"
         "VLA-SCALEENTITY"
         "VLA-SECTIONSOLID"
         "VLA-SELECT"
         "VLA-SELECTATPOINT"
         "VLA-SELECTBYPOLYGON"
         "VLA-SELECTONSCREEN"
         "VLA-SENDCOMMAND"
         "VLA-SETBITMAPS"
         "VLA-SETBULGE"
         "VLA-SETCONTROLPOINT"
         "VLA-SETCUSTOMSCALE"
         "VLA-SETFITPOINT"
         "VLA-SETFONT"
         "VLA-SETGRIDSPACING"
         "VLA-SETINVISIBLEEDGE"
         "VLA-SETLAYOUTSTOPLOT"
         "VLA-SETPATTERN"
         "VLA-SETPROJECTFILEPATH"
         "VLA-SETSNAPSPACING"
         "VLA-SETVARIABLE"
         "VLA-SETVIEW"
         "VLA-SETWEIGHT"
         "VLA-SETWIDTH"
         "VLA-SETWINDOWTOPLOT"
         "VLA-SETXDATA"
         "VLA-SETXRECORDDATA"
         "VLA-SLICESOLID"
         "VLA-SPLIT"
         "VLA-STARTBATCHMODE"
         "VLA-STARTUNDOMARK"
         "VLA-TRANSFORMBY"
         "VLA-TRANSLATECOORDINATES"
         "VLA-UNLOAD"
         "VLA-UNLOADADS"
         "VLA-UNLOADARX"
         "VLA-UNLOADDVB"
         "VLA-UPDATE"
         "VLA-WBLOCK"
         "VLA-ZOOMALL"
         "VLA-ZOOMCENTER"
         "VLA-ZOOMEXTENTS"
         "VLA-ZOOMPICKWINDOW"
         "VLA-ZOOMSCALED"
         "VLA-ZOOMWINDOW"
         "VLAX-3D-POINT"
         "VLAX-ADD-CMD"
         "VLAX-COUNT"
         "VLAX-CREATE-OBJECT"
         "VLAX-CURVE-GETAREA"
         "VLAX-CURVE-GETCLOSESTPOINTTO"
         "VLAX-CURVE-GETCLOSESTPOINTTOPROJECTION"
         "VLAX-CURVE-GETDISTATPARAM"
         "VLAX-CURVE-GETDISTATPOINT"
         "VLAX-CURVE-GETENDPARAM"
         "VLAX-CURVE-GETENDPOINT"
         "VLAX-CURVE-GETFIRSTDERIV"
         "VLAX-CURVE-GETPARAMATDIST"
         "VLAX-CURVE-GETPARAMATPOINT"
         "VLAX-CURVE-GETPOINTATDIST"
         "VLAX-CURVE-GETPOINTATPARAM"
         "VLAX-CURVE-GETSECONDDERIV"
         "VLAX-CURVE-GETSTARTPARAM"
         "VLAX-CURVE-GETSTARTPOINT"
         "VLAX-CURVE-ISCLOSED"
         "VLAX-CURVE-ISPERIODIC"
         "VLAX-CURVE-ISPLANAR"
         "VLAX-DISABLE-DOCACTIVATION"
         "VLAX-DUMP-OBJECT"
         "VLAX-ENABLE-DOCACTIVATION"
         "VLAX-ENAME->VLA-OBJECT"
         "VLAX-ERASED-P"
         "VLAX-GET"
         "VLAX-GET-ACAD-OBJECT"
         "VLAX-GET-OBJECT"
         "VLAX-GET-OR-CREATE-OBJECT"
         "VLAX-GET-PROPERTY"
         "VLAX-IMPORT-TYPE-LIBRARY"
         "VLAX-INVOKE"
         "VLAX-INVOKE-METHOD"
         "VLAX-ITEM"
         "VLAX-LDATA-DELETE"
         "VLAX-LDATA-GET"
         "VLAX-LDATA-LIST"
         "VLAX-LDATA-PUT"
         "VLAX-LDATA-TEST"
         "VLAX-MAKE-SAFEARRAY"
         "VLAX-MAKE-VARIANT"
         "VLAX-MAP-COLLECTION"
         "VLAX-METHOD-APPLICABLE-P"
         "VLAX-NEW-DOCUMENT"
         "VLAX-OBJECT-RELEASED-P"
         "VLAX-OPEN-DOCUMENT"
         "VLAX-MACHINE-PRODUCT-KEY"
         "VLAX-USER-PRODUCT-KEY"
         "VLAX-PROPERTY-AVAILABLE-P"
         "VLAX-PUT"
         "VLAX-PUT-PROPERTY"
         "VLAX-QUEUEEXPR"
         "VLAX-READ-ENABLED-P"
         "VLAX-REG-APP"
         "VLAX-RELEASE-OBJECT"
         "VLAX-REMOVE-CMD"
         "VLAX-SAFEARRAY->LIST"
         "VLAX-SAFEARRAY-FILL"
         "VLAX-SAFEARRAY-GET-DIM"
         "VLAX-SAFEARRAY-GET-ELEMENT"
         "VLAX-SAFEARRAY-GET-L-BOUND"
         "VLAX-SAFEARRAY-GET-U-BOUND"
         "VLAX-SAFEARRAY-PUT-ELEMENT"
         "VLAX-SAFEARRAY-TYPE"
         "VLAX-TMATRIX"
         "VLAX-TYPEINFO-AVAILABLE-P"
         "VLAX-VARIANT-CHANGE-TYPE"
         "VLAX-VARIANT-TYPE"
         "VLAX-VARIANT-VALUE"
         "VLAX-VBABORT"
         "VLAX-VBABORTRETRYIGNORE"
         "VLAX-VBAPPLICATIONMODAL"
         "VLAX-VBARCHIVE"
         "VLAX-VBARRAY"
         "VLAX-VBBOOLEAN"
         "VLAX-VBCANCEL"
         "VLAX-VBCRITICAL"
         "VLAX-VBCURRENCY"
         "VLAX-VBDATAOBJECT"
         "VLAX-VBDATE"
         "VLAX-VBDEFAULTBUTTON1"
         "VLAX-VBDEFAULTBUTTON2"
         "VLAX-VBDEFAULTBUTTON3"
         "VLAX-VBDIRECTORY"
         "VLAX-VBDOUBLE"
         "VLAX-VBEMPTY"
         "VLAX-VBERROR"
         "VLAX-VBEXCLAMATION"
         "VLAX-VBHIDDEN"
         "VLAX-VBHIRAGANA"
         "VLAX-VBIGNORE"
         "VLAX-VBINFORMATION"
         "VLAX-VBINTEGER"
         "VLAX-VBKATAKANA"
         "VLAX-VBLONG"
         "VLAX-VBLOWERCASE"
         "VLAX-VBNARROW"
         "VLAX-VBNO"
         "VLAX-VBNORMAL"
         "VLAX-VBNULL"
         "VLAX-VBOBJECT"
         "VLAX-VBOK"
         "VLAX-VBOKCANCEL"
         "VLAX-VBOKONLY"
         "VLAX-VBPROPERCASE"
         "VLAX-VBQUESTION"
         "VLAX-VBREADONLY"
         "VLAX-VBRETRY"
         "VLAX-VBRETRYCANCEL"
         "VLAX-VBSINGLE"
         "VLAX-VBSTRING"
         "VLAX-VBSYSTEM"
         "VLAX-VBSYSTEMMODAL"
         "VLAX-VBUPPERCASE"
         "VLAX-VBVARIANT"
         "VLAX-VBVOLUME"
         "VLAX-VBWIDE"
         "VLAX-VBYES"
         "VLAX-VBYESNO"
         "VLAX-VBYESNOCANCEL"
         "VLAX-VLA-OBJECT->ENAME"
         "VLAX-WRITE-ENABLED-P"
         "VLR-ACDB-REACTOR"
         "VLR-ADD"
         "VLR-ADDED-P"
         "VLR-BEEP-REACTION"
         "VLR-COMMAND-REACTOR"
         "VLR-CURRENT-REACTION-NAME"
         "VLR-DATA"
         "VLR-DATA-SET"
         "VLR-DEEPCLONE-REACTOR"
         "VLR-DOCMANAGER-REACTOR"
         "VLR-DOCUMENT"
         "VLR-DWG-REACTOR"
         "VLR-DXF-REACTOR"
         "VLR-EDITOR-REACTOR"
         "VLR-INSERT-REACTOR"
         "VLR-LINKER-REACTOR"
         "VLR-LISP-REACTOR"
         "VLR-MISCELLANEOUS-REACTOR"
         "VLR-MOUSE-REACTOR"
         "VLR-OBJECT-REACTOR"
         "VLR-OWNER-ADD"
         "VLR-OWNER-REMOVE"
         "VLR-OWNERS"
         "VLR-PERS"
         "VLR-PERS-ACTIVATE"
         "VLR-PERS-DICTNAME"
         "VLR-PERS-LIST"
         "VLR-PERS-P"
         "VLR-PERS-RELEASE"
         "VLR-RANGE"
         "VLR-RANGE-SET"
         "VLR-REACTION-NAMES"
         "VLR-REACTION-SET"
         "VLR-REACTIONS"
         "VLR-REACTOR.GETDICTKEY"
         "VLR-REACTORS"
         "VLR-REMOVE"
         "VLR-REMOVE-ALL"
         "VLR-SYSVAR-REACTOR"
         "VLR-TOOLBAR-REACTOR"
         "VLR-TRACE-REACTION"
         "VLR-TYPE"
         "VLR-TYPES"
         "VLR-UNDO-REACTOR"
         "VLR-WBLOCK-REACTOR"
         "VLR-WINDOW-REACTOR"
         "VLR-XREF-REACTOR"
        )
 )
 (setq reactor-symbol-list
       '(
        )
 )


(princ)
